"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocLink = void 0;
exports.useDocLinks = useDocLinks;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Creates links to the documentation.
 *
 * @see {@link DocLink} for a component that creates a link to the docs.
 *
 * @example
 * ```typescript
 * <DocLink app="elasticsearch" doc="built-in-roles.html">
 *   Learn what privileges individual roles grant.
 * </DocLink>
 * ```
 *
 * @example
 * ```typescript
 * const [docs] = useDocLinks();
 *
 * <EuiLink href={docs.dashboard.guide} target="_blank" external>
 *   Learn how to get started with dashboards.
 * </EuiLink>
 * ```
 */
function useDocLinks() {
  const {
    services
  } = (0, _public.useKibana)();
  const {
    links,
    ELASTIC_WEBSITE_URL,
    DOC_LINK_VERSION
  } = services.docLinks;
  const getDocLink = (0, _react.useCallback)((app, doc) => {
    return `${ELASTIC_WEBSITE_URL}guide/en/${app}/reference/${DOC_LINK_VERSION}/${doc}`;
  }, [ELASTIC_WEBSITE_URL, DOC_LINK_VERSION]);
  return [links, getDocLink];
}
const DocLink = ({
  app,
  doc,
  children
}) => {
  const [, getDocLink] = useDocLinks();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: getDocLink(app, doc),
    target: "_blank",
    external: true
  }, children);
};
exports.DocLink = DocLink;