"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.App = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _components = require("./components");
var _contexts = require("./contexts");
var _lib = require("./lib");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const App = () => {
  const {
    getLicenseStatus,
    notifications
  } = (0, _contexts.useAppContext)();
  const {
    activeTab,
    currentResponse,
    highlightDetails,
    pristine,
    profiling
  } = (0, _contexts.useProfilerReadContext)();
  const dispatch = (0, _contexts.useProfilerActionContext)();
  const handleProfileTreeError = e => {
    notifications.addError(e, {
      title: _i18n.i18n.translate('xpack.searchProfiler.profileTreeErrorRenderTitle', {
        defaultMessage: 'Profile data cannot be parsed.'
      })
    });
  };
  const setActiveTab = (0, _react.useCallback)(target => dispatch({
    type: 'setActiveTab',
    value: target
  }), [dispatch]);
  const onHighlight = (0, _react.useCallback)(value => dispatch({
    type: 'setHighlightDetails',
    value
  }), [dispatch]);
  const renderLicenseWarning = () => {
    return !getLicenseStatus().valid ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_components.LicenseWarningNotice, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    })) : null;
  };
  const renderProfileTreeArea = () => {
    if (profiling) {
      return /*#__PURE__*/_react.default.createElement(_components.ProfileLoadingPlaceholder, null);
    }
    if (activeTab) {
      return /*#__PURE__*/_react.default.createElement(_components.ProfileTree, {
        onDataInitError: handleProfileTreeError,
        onHighlight: onHighlight,
        target: activeTab,
        data: currentResponse
      });
    }
    if (getLicenseStatus().valid && pristine) {
      return /*#__PURE__*/_react.default.createElement(_components.EmptyTreePlaceHolder, null);
    }
    return null;
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    className: "prfDevTool__page appRoot"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    className: "prfDevTool__page__pageBody"
  }, renderLicenseWarning(), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    className: "prfDevTool__page__pageBodyContent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s",
    direction: "row",
    className: "prfDevTool__page__bodyGroup"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_components.ProfileQueryEditor, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "prfDevTool__main",
    gutterSize: "none",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_components.SearchProfilerTabs, {
    activeTab: activeTab,
    activateTab: setActiveTab,
    has: {
      aggregations: Boolean(currentResponse && (0, _lib.hasAggregations)(currentResponse)),
      searches: Boolean(currentResponse && (0, _lib.hasSearch)(currentResponse))
    }
  }), renderProfileTreeArea()))), highlightDetails ? /*#__PURE__*/_react.default.createElement(_components.HighlightDetailsFlyout, (0, _extends2.default)({}, highlightDetails, {
    onClose: () => dispatch({
      type: 'setHighlightDetails',
      value: null
    })
  })) : null))));
};
exports.App = App;