"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchSearchResults = void 0;
var _types = require("../types");
var _escape_lucene_charts = require("../utils/escape_lucene_charts");
var _fetch_with_pagination = require("../utils/fetch_with_pagination");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const fetchSearchResults = async (client, indexName, query, from = 0, size = _types.DEFAULT_DOCS_PER_PAGE) => {
  const result = await (0, _fetch_with_pagination.fetchWithPagination)(async () => await client.asCurrentUser.search({
    from,
    index: indexName,
    size,
    ...(!!query ? {
      q: (0, _escape_lucene_charts.escapeLuceneChars)(query)
    } : {})
  }), from, size);
  return {
    ...result,
    data: result.data
  };
};
exports.fetchSearchResults = fetchSearchResults;