"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateConnectorServiceType = void 0;
var _i18n = require("@kbn/i18n");
var _ = require("..");
var _connectors = require("../types/connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const updateConnectorServiceType = async (client, connectorId, serviceType) => {
  const connectorResult = await (0, _.fetchConnectorById)(client, connectorId);
  if (connectorResult !== null && connectorResult !== void 0 && connectorResult.value) {
    const result = await client.index({
      document: {
        ...connectorResult.value,
        configuration: {},
        service_type: serviceType,
        status: _connectors.ConnectorStatus.NEEDS_CONFIGURATION
      },
      id: connectorId,
      index: _.CONNECTORS_INDEX,
      if_seq_no: connectorResult.seqNo,
      if_primary_term: connectorResult.primaryTerm
    });
    return result;
  } else {
    throw new Error(_i18n.i18n.translate('searchConnectors.server.connectors.serviceType.error', {
      defaultMessage: 'Could not find document'
    }));
  }
};
exports.updateConnectorServiceType = updateConnectorServiceType;