"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateConnectorIndexName = void 0;
var _i18n = require("@kbn/i18n");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const updateConnectorIndexName = async (client, connectorId, indexName) => {
  const connectorResult = await (0, _.fetchConnectorByIndexName)(client, indexName);
  if (connectorResult) {
    throw new Error(_i18n.i18n.translate('searchConnectors.server.connectors.indexName.error', {
      defaultMessage: 'This index has already been registered to connector {connectorId}. Please delete that connector or select a different index name.',
      values: {
        connectorId
      }
    }));
  }
  return await client.update({
    index: _.CONNECTORS_INDEX,
    doc: {
      index_name: indexName
    },
    id: connectorId
  });
};
exports.updateConnectorIndexName = updateConnectorIndexName;