"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyncJobsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ = require("../..");
var _duration_to_text = require("../../utils/duration_to_text");
var _formatted_date_time = require("../../utils/formatted_date_time");
var _sync_job_flyout = require("./sync_job_flyout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const SyncJobsTable = ({
  isLoading,
  onPaginate,
  pagination,
  syncJobs,
  type
}) => {
  const [selectedSyncJob, setSelectedSyncJob] = (0, _react.useState)(undefined);
  const columns = [{
    field: 'completed_at',
    name: _i18n.i18n.translate('searchConnectors.syncJobs.lastSync.columnTitle', {
      defaultMessage: 'Last sync'
    }),
    render: lastSync => lastSync ? /*#__PURE__*/_react.default.createElement(_formatted_date_time.FormattedDateTime, {
      date: new Date(lastSync)
    }) : '--',
    sortable: true,
    truncateText: false
  }, {
    name: _i18n.i18n.translate('searchConnectors.syncJobs.syncDuration.columnTitle', {
      defaultMessage: 'Sync duration'
    }),
    render: syncJob => (0, _duration_to_text.durationToText)((0, _duration_to_text.getSyncJobDuration)(syncJob)),
    truncateText: false
  }, ...(type === 'content' ? [{
    field: 'indexed_document_count',
    name: _i18n.i18n.translate('searchConnectors.searchIndices.addedDocs.columnTitle', {
      defaultMessage: 'Docs added'
    }),
    sortable: true,
    truncateText: true
  }, {
    field: 'deleted_document_count',
    name: _i18n.i18n.translate('searchConnectors.searchIndices.deletedDocs.columnTitle', {
      defaultMessage: 'Docs deleted'
    }),
    sortable: true,
    truncateText: true
  }, {
    field: 'job_type',
    name: _i18n.i18n.translate('searchConnectors.searchIndices.syncJobType.columnTitle', {
      defaultMessage: 'Content sync type'
    }),
    render: syncType => {
      const syncJobTypeText = (0, _.syncJobTypeToText)(syncType);
      if (syncJobTypeText.length === 0) return null;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow"
      }, syncJobTypeText);
    },
    sortable: true,
    truncateText: true
  }] : []), ...(type === 'access_control' ? [{
    field: 'indexed_document_count',
    name: _i18n.i18n.translate('searchConnectors.searchIndices.identitySync.columnTitle', {
      defaultMessage: 'Identities synced'
    }),
    sortable: true,
    truncateText: true
  }] : []), {
    field: 'status',
    name: _i18n.i18n.translate('searchConnectors.searchIndices.syncStatus.columnTitle', {
      defaultMessage: 'Status'
    }),
    render: syncStatus => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: (0, _.syncStatusToColor)(syncStatus)
    }, (0, _.syncStatusToText)(syncStatus)),
    truncateText: true
  }, {
    actions: [{
      description: _i18n.i18n.translate('searchConnectors.index.syncJobs.actions.viewJob.title', {
        defaultMessage: 'View this sync job'
      }),
      icon: 'eye',
      isPrimary: false,
      name: _i18n.i18n.translate('searchConnectors.index.syncJobs.actions.viewJob.caption', {
        defaultMessage: 'View this sync job'
      }),
      onClick: job => setSelectedSyncJob(job),
      type: 'icon'
    }]
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, Boolean(selectedSyncJob) && /*#__PURE__*/_react.default.createElement(_sync_job_flyout.SyncJobFlyout, {
    onClose: () => setSelectedSyncJob(undefined),
    syncJob: selectedSyncJob
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": `entSearchContent-index-${type}-syncJobs-table`,
    items: syncJobs,
    columns: columns,
    hasActions: true,
    onChange: onPaginate,
    pagination: pagination,
    tableLayout: "fixed",
    loading: isLoading
  }));
};
exports.SyncJobsTable = SyncJobsTable;