"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorConfigurationForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _utils = require("../../utils");
var _connector_configuration_utils = require("../../utils/connector_configuration_utils");
var _connector_configuration_form_items = require("./connector_configuration_form_items");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function configViewToConfigValues(configView) {
  const result = {};
  for (const {
    key,
    value
  } of configView.advancedConfigurations) {
    result[key] = value;
  }
  for (const {
    key,
    value
  } of configView.unCategorizedItems) {
    result[key] = value;
  }
  return result;
}
const ConnectorConfigurationForm = ({
  cancelEditing,
  configuration,
  hasDocumentLevelSecurity,
  isLoading,
  isNative,
  saveConfig
}) => {
  const [localConfig, setLocalConfig] = (0, _react.useState)(configuration);
  const [configView, setConfigView] = (0, _react.useState)((0, _connector_configuration_utils.sortAndFilterConnectorConfiguration)(configuration, isNative));
  (0, _react.useEffect)(() => {
    setLocalConfig(localConf => ({
      ...configuration,
      ...localConf
    }));
  }, [configuration]);
  (0, _react.useEffect)(() => {
    setConfigView((0, _connector_configuration_utils.sortAndFilterConnectorConfiguration)(localConfig, isNative));
  }, [localConfig, isNative]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    onSubmit: event => {
      event.preventDefault();
      saveConfig(configViewToConfigValues(configView));
    },
    component: "form"
  }, /*#__PURE__*/_react.default.createElement(_connector_configuration_form_items.ConnectorConfigurationFormItems, {
    isLoading: isLoading,
    items: configView.unCategorizedItems,
    hasDocumentLevelSecurityEnabled: hasDocumentLevelSecurity,
    setConfigEntry: (key, value) => {
      const entry = localConfig[key];
      if (entry && !(0, _utils.isCategoryEntry)(entry)) {
        const newConfiguration = {
          ...localConfig,
          [key]: {
            ...entry,
            value
          }
        };
        setLocalConfig(newConfiguration);
      }
    }
  }), configView.categories.map((category, index) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: index
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, category.label)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_connector_configuration_form_items.ConnectorConfigurationFormItems, {
    isLoading: isLoading,
    items: category.configEntries,
    hasDocumentLevelSecurityEnabled: hasDocumentLevelSecurity,
    setConfigEntry: (key, value) => {
      const categories = configView.categories;
      categories[index] = {
        ...categories[index],
        [key]: value
      };
      setConfigView({
        ...configView,
        categories
      });
    }
  }))), configView.advancedConfigurations.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('searchConnectors.configurationConnector.config.advancedConfigurations.title', {
    defaultMessage: 'Advanced Configurations'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_connector_configuration_form_items.ConnectorConfigurationFormItems, {
    isLoading: isLoading,
    items: configView.advancedConfigurations,
    hasDocumentLevelSecurityEnabled: hasDocumentLevelSecurity,
    setConfigEntry: (key, value) => {
      setConfigView({
        ...configView,
        advancedConfigurations: configView.advancedConfigurations.map(config => config.key === key ? {
          ...config,
          value
        } : config)
      });
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "entSearchContent-connector-configuration-saveConfiguration",
    "data-telemetry-id": "entSearchContent-connector-configuration-saveConfiguration",
    type: "submit",
    isLoading: isLoading
  }, _i18n.i18n.translate('searchConnectors.configurationConnector.config.submitButton.title', {
    defaultMessage: 'Save configuration'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-telemetry-id": "entSearchContent-connector-configuration-cancelEdit",
    isDisabled: isLoading,
    onClick: () => {
      cancelEditing();
    }
  }, _i18n.i18n.translate('searchConnectors.configurationConnector.config.cancelEditingButton.title', {
    defaultMessage: 'Cancel'
  }))))));
};
exports.ConnectorConfigurationForm = ConnectorConfigurationForm;