"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TagManagementPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _edition_modal = require("../components/edition_modal");
var _components = require("./components");
var _actions = require("./actions");
var _bulk_actions = require("./bulk_actions");
var _utils = require("./utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TagManagementPage = ({
  setBreadcrumbs,
  core,
  tagClient,
  tagCache,
  assignmentService,
  capabilities,
  assignableTypes
}) => {
  const {
    overlays,
    notifications,
    application,
    http,
    theme
  } = core;
  const [loading, setLoading] = (0, _react.useState)(false);
  const [allTags, setAllTags] = (0, _react.useState)([]);
  const [selectedTags, setSelectedTags] = (0, _react.useState)([]);
  const [query, setQuery] = (0, _react.useState)();
  const filteredTags = (0, _react.useMemo)(() => {
    return query ? _eui.Query.execute(query, allTags) : allTags;
  }, [allTags, query]);
  const unmount$ = (0, _react.useMemo)(() => {
    return new _rxjs.Subject();
  }, []);
  (0, _react.useEffect)(() => {
    return () => {
      unmount$.next();
    };
  }, [unmount$]);
  const fetchTags = (0, _react.useCallback)(async () => {
    setLoading(true);
    const {
      tags
    } = await tagClient.find({
      page: 1,
      perPage: 10000
    });
    setAllTags(tags);
    setLoading(false);
  }, [tagClient]);
  (0, _useMount.default)(() => {
    fetchTags();
  });
  const createModalOpener = (0, _react.useMemo)(() => (0, _edition_modal.getCreateModalOpener)({
    overlays,
    theme,
    tagClient,
    notifications
  }), [overlays, theme, tagClient, notifications]);
  const tableActions = (0, _react.useMemo)(() => {
    return (0, _actions.getTableActions)({
      core,
      capabilities,
      tagClient,
      tagCache,
      assignmentService,
      setLoading,
      assignableTypes,
      fetchTags,
      canceled$: unmount$
    });
  }, [core, capabilities, tagClient, tagCache, assignmentService, setLoading, assignableTypes, fetchTags, unmount$]);
  const bulkActions = (0, _react.useMemo)(() => {
    return (0, _bulk_actions.getBulkActions)({
      core,
      capabilities,
      tagClient,
      tagCache,
      assignmentService,
      setLoading,
      assignableTypes,
      clearSelection: () => setSelectedTags([])
    });
  }, [core, capabilities, tagClient, tagCache, assignmentService, assignableTypes]);
  (0, _react.useEffect)(() => {
    setBreadcrumbs([{
      text: _i18n.i18n.translate('xpack.savedObjectsTagging.management.breadcrumb.index', {
        defaultMessage: 'Tags'
      })
    }]);
  }, [setBreadcrumbs]);
  const openCreateModal = (0, _react.useCallback)(() => {
    createModalOpener({
      onCreate: createdTag => {
        fetchTags();
        notifications.toasts.addSuccess({
          title: _i18n.i18n.translate('xpack.savedObjectsTagging.notifications.createTagSuccessTitle', {
            defaultMessage: 'Created "{name}" tag',
            values: {
              name: createdTag.name
            }
          })
        });
      }
    });
  }, [notifications, createModalOpener, fetchTags]);
  const getTagRelationUrl = (0, _react.useCallback)(tag => {
    return (0, _utils.getTagConnectionsUrl)(tag, http.basePath);
  }, [http]);
  const showTagRelations = (0, _react.useCallback)(tag => {
    application.navigateToUrl(getTagRelationUrl(tag));
  }, [application, getTagRelationUrl]);
  const executeBulkAction = (0, _react.useCallback)(async action => {
    try {
      await action.execute(selectedTags.map(({
        id
      }) => id), {
        canceled$: unmount$
      });
    } catch (e) {
      notifications.toasts.addError(e, {
        title: _i18n.i18n.translate('xpack.savedObjectsTagging.notifications.bulkActionError', {
          defaultMessage: 'An error occurred'
        })
      });
    } finally {
      setLoading(false);
    }
    if (action.refreshAfterExecute) {
      await fetchTags();
    }
  }, [selectedTags, fetchTags, notifications, unmount$]);
  const actionBar = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_components.ActionBar, {
    actions: bulkActions,
    totalCount: filteredTags.length,
    selectedCount: selectedTags.length,
    onActionSelected: executeBulkAction
  }), [selectedTags, filteredTags, bulkActions, executeBulkAction]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_components.Header, {
    canCreate: capabilities.create,
    onCreate: openCreateModal
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_components.TagTable, {
    loading: loading,
    tags: filteredTags,
    capabilities: capabilities,
    actionBar: actionBar,
    actions: tableActions,
    initialQuery: query,
    onQueryChange: newQuery => {
      setQuery(newQuery);
      setSelectedTags([]);
    },
    allowSelection: bulkActions.length > 0,
    selectedTags: selectedTags,
    onSelectionChange: tags => {
      setSelectedTags(tags);
    },
    getTagRelationUrl: getTagRelationUrl,
    onShowRelations: tag => {
      showTagRelations(tag);
    }
  }));
};
exports.TagManagementPage = TagManagementPage;