"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBulkAssignAction = void 0;
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _i18n = require("@kbn/i18n");
var _assign_flyout = require("../../components/assign_flyout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getBulkAssignAction = ({
  overlays,
  notifications,
  theme,
  tagCache,
  assignmentService,
  assignableTypes
}) => {
  const openFlyout = (0, _assign_flyout.getAssignFlyoutOpener)({
    overlays,
    notifications,
    theme,
    tagCache,
    assignmentService,
    assignableTypes
  });
  return {
    id: 'assign',
    label: _i18n.i18n.translate('xpack.savedObjectsTagging.management.actions.bulkAssign.label', {
      defaultMessage: 'Manage tag assignments'
    }),
    icon: 'tag',
    refreshAfterExecute: true,
    execute: async (tagIds, {
      canceled$
    }) => {
      const flyout = await openFlyout({
        tagIds
      });

      // close the flyout when the action is canceled
      // this is required when the user navigates away from the page
      canceled$.pipe((0, _operators.takeUntil)((0, _rxjs.from)(flyout.onClose))).subscribe(() => {
        flyout.close();
      });
      return flyout.onClose;
    }
  };
};
exports.getBulkAssignAction = getBulkAssignAction;