"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useValidation = void 0;
var _react = require("react");
var _rxjs = require("rxjs");
var _useObservable2 = _interopRequireDefault(require("react-use/lib/useObservable"));
var _common = require("../../../common");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialValidation = {
  valid: true,
  warnings: [],
  errors: {}
};
const useValidation = ({
  tagAttributes,
  tagClient,
  validateDuplicateNameOnMount = false
}) => {
  var _useObservable;
  const isMounted = (0, _react.useRef)(false);
  const [validation, setValidation] = (0, _react.useState)(initialValidation);
  const {
    errors: {
      name: nameError
    }
  } = validation;
  const validation$ = (0, _react.useMemo)(() => new _rxjs.BehaviorSubject({
    isValidating: false,
    hasDuplicateNameError: false
  }), []);
  const {
    isValidating = false
  } = (_useObservable = (0, _useObservable2.default)(validation$)) !== null && _useObservable !== void 0 ? _useObservable : {};
  const setIsValidating = (0, _react.useCallback)(value => {
    validation$.next({
      ...validation$.value,
      isValidating: value
    });
  }, [validation$]);
  const validateDuplicateTagName = (0, _react.useCallback)(async name => {
    const error = (0, _common.validateTagName)(name);
    if (error) {
      return;
    }
    const existingTag = await tagClient.findByName(name, {
      exact: true
    });
    if (existingTag) {
      setValidation(prev => ({
        ...prev,
        valid: false,
        errors: {
          ...prev.errors,
          name: _utils.duplicateTagNameErrorMessage
        }
      }));
    }
    setIsValidating(false);
  }, [tagClient, setIsValidating]);
  const onNameChange = (0, _react.useCallback)(async (name, {
    debounced = false,
    hasBeenModified = true
  } = {}) => {
    setIsValidating(true);
    if (debounced) {
      if (hasBeenModified) {
        await validateDuplicateTagName(name);
      }
      setIsValidating(false);
    }
  }, [setIsValidating, validateDuplicateTagName]);
  (0, _react.useEffect)(() => {
    if (isMounted.current) {
      onNameChange(tagAttributes.name);
    }
  }, [onNameChange, tagAttributes.name]);
  (0, _react.useEffect)(() => {
    if (isMounted.current) {
      setValidation((0, _utils.validateTag)(tagAttributes));
    }
  }, [tagAttributes]);
  (0, _react.useEffect)(() => {
    if (validateDuplicateNameOnMount && tagAttributes.name && !isMounted.current) {
      setIsValidating(true);
      validateDuplicateTagName(tagAttributes.name);
    }
    isMounted.current = true;
  }, [validateDuplicateNameOnMount, tagAttributes.name, validateDuplicateTagName, validation$, setIsValidating]);
  (0, _react.useEffect)(() => {
    validation$.next({
      ...validation$.value,
      hasDuplicateNameError: nameError === _utils.duplicateTagNameErrorMessage
    });
  }, [nameError, validation$]);
  return {
    validation,
    setValidation,
    isValidating,
    validation$,
    onNameChange
  };
};
exports.useValidation = useValidation;