"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateOrEditModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _common = require("../../../common");
var _ = require("..");
var _utils = require("./utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateOrEditModal = ({
  onClose,
  onSubmit,
  onNameChange,
  validation,
  isValidating,
  setField,
  tag,
  mode
}) => {
  const optionalMessageId = (0, _eui.htmlIdGenerator)()();
  const ifMounted = (0, _utils.useIfMounted)();
  const [submitting, setSubmitting] = (0, _react.useState)(false);
  const lastNameValue = (0, _react.useRef)(tag.name);

  // we don't want this value to change when the user edits the tag
  // eslint-disable-next-line react-hooks/exhaustive-deps
  const initialTag = (0, _react.useMemo)(() => tag, []);
  const tagHasBeenModified = (0, _react.useMemo)(() => tag.name !== initialTag.name || tag.color !== initialTag.color || tag.description !== initialTag.description, [initialTag, tag]);
  const nameHasBeenModified = tag.name !== lastNameValue.current;
  const setName = (0, _react.useMemo)(() => setField('name'), [setField]);
  const setColor = (0, _react.useMemo)(() => setField('color'), [setField]);
  const setDescription = (0, _react.useMemo)(() => setField('description'), [setField]);
  const isEdit = (0, _react.useMemo)(() => mode === 'edit', [mode]);
  const previewTag = (0, _react.useMemo)(() => {
    return {
      ...tag,
      name: tag.name || 'tag',
      color: (0, _common.validateTagColor)(tag.color) ? '#000000' : tag.color
    };
  }, [tag]);
  const onFormSubmit = (0, _react.useCallback)(async () => {
    setSubmitting(true);
    await onSubmit();
    // onSubmit can close the modal, causing errors in the console when the component tries to setState.
    ifMounted(() => {
      setSubmitting(false);
    });
  }, [ifMounted, onSubmit]);
  (0, _useDebounce.default)(() => {
    onNameChange(tag.name, {
      debounced: true,
      hasBeenModified: nameHasBeenModified
    });
    lastNameValue.current = tag.name;
  }, 300, [tag.name, nameHasBeenModified]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose,
    initialFocus: "[name=name]",
    style: {
      minWidth: '600px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, isEdit ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.savedObjectsTagging.management.editModal.title",
    defaultMessage: "Edit '{name}' tag",
    values: {
      name: initialTag.name
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.savedObjectsTagging.management.createModal.title",
    defaultMessage: "Create tag"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": "tagModalForm",
    component: "form"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "baseline"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "createModalRow-name",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.savedObjectsTagging.tagAttributeLabels.name', {
      defaultMessage: 'Name'
    }),
    isInvalid: !!validation.errors.name,
    error: validation.errors.name
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "tag-name",
    fullWidth: true,
    maxLength: _common.tagNameMaxLength,
    value: tag.name,
    onChange: e => setName(e.target.value),
    isLoading: isValidating,
    "data-test-subj": "createModalField-name"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "createModalRow-color",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.savedObjectsTagging.tagAttributeLabels.color', {
      defaultMessage: 'Color'
    }),
    isInvalid: !!validation.errors.color,
    error: validation.errors.color,
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: () => setColor((0, _utils.getRandomColor)()),
      size: "xs",
      style: {
        height: '18px',
        fontSize: '0.75rem'
      },
      "aria-label": _i18n.i18n.translate('xpack.savedObjectsTagging.management.createModal.color.randomizeAriaLabel', {
        defaultMessage: 'Randomize tag color'
      })
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.savedObjectsTagging.management.createModal.color.randomize",
      defaultMessage: "Randomize"
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
    color: tag.color,
    fullWidth: true,
    onChange: text => setColor(text),
    format: "hex",
    "data-test-subj": "createModalField-color"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "createModalRow-description",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.savedObjectsTagging.tagAttributeLabels.description', {
      defaultMessage: 'Description'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      id: optionalMessageId
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.savedObjectsTagging.management.optionalFieldText",
      defaultMessage: "Optional"
    })),
    isInvalid: !!validation.errors.description,
    error: validation.errors.description
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    name: "description",
    value: tag.description,
    maxLength: _common.tagDescriptionMaxLength,
    onChange: e => setDescription(e.target.value),
    "data-test-subj": "createModalField-description",
    resize: "none",
    fullWidth: true,
    compressed: true,
    "aria-describedby": optionalMessageId
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "baseline"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "spaceBetween",
    alignItems: "baseline"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.savedObjectsTagging.management.tagPreviewText",
    defaultMessage: "Preview"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_.TagBadge, {
    tag: previewTag
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "baseline"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    "data-test-subj": "createModalCancelButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.savedObjectsTagging.management.createModal.closeButtonText",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: isEdit ? 'save' : 'tag',
    color: "primary",
    fill: true,
    "data-test-subj": "createModalConfirmButton",
    onClick: onFormSubmit,
    isLoading: submitting,
    isDisabled: submitting || isEdit && !tagHasBeenModified
  }, isEdit ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.savedObjectsTagging.management.createModal.updateTagButtonLabel",
    defaultMessage: "Save changes"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.savedObjectsTagging.management.createModal.createTagButtonLabel",
    defaultMessage: "Create tag"
  }))))))));
};
exports.CreateOrEditModal = CreateOrEditModal;