"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TagSelector = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _utils = require("../../utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createOptionValue = {
  type: '__create_option__'
};
function isTagOption(option) {
  const value = option.value;
  return value.name !== undefined && value.color !== undefined && value.id !== undefined;
}
function isCreateOption(option) {
  const value = option.value;
  return value.type === '__create_option__';
}
const renderCreateOption = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": `tagSelectorOption-action__create`,
    gutterSize: "xs",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "tag"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.savedObjectsTagging.components.tagSelector.createTagOptionLabel",
    defaultMessage: "Create tag"
  }))));
};
const renderTagOption = (option, searchValue, contentClassName) => {
  var _option$value;
  const {
    name,
    color
  } = (_option$value = option.value) !== null && _option$value !== void 0 ? _option$value : {
    name: ''
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: color,
    "data-test-subj": `tagSelectorOption-${(0, _utils.testSubjFriendly)(name)}`
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: contentClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
    search: searchValue
  }, name)));
};
const renderOption = (option, searchValue, contentClassName) => {
  if (isCreateOption(option)) {
    return renderCreateOption();
  }
  // just having an if/else block is not enough for TS to infer the type in the else block. strange...
  if (isTagOption(option)) {
    return renderTagOption(option, searchValue, contentClassName);
  }
};
const TagSelector = ({
  tags,
  selected,
  onTagsSelected,
  allowCreate,
  openCreateModal,
  fullWidth = true,
  ...otherProps
}) => {
  const [currentSearch, setCurrentSearch] = (0, _react.useState)('');

  // We are forcing the 'create tag' option to always appear by having its
  // label matching the current search term. This is a workaround to address
  // the 'limitations' of the combobox that does not allow that feature
  // out of the box
  const createTagOption = (0, _react.useMemo)(() => {
    // label and color will never be actually used for rendering.
    // label will only be used to check if the option matches the search,
    // which will always be true because we set its value to the current search.
    // The extra whitespace is required to avoid the combobox to consider that the value
    // is selected when closing the dropdown
    return {
      label: `${currentSearch} `,
      color: '#FFFFFF',
      value: createOptionValue
    };
  }, [currentSearch]);

  // we append the 'create' option if user is allowed to create tags
  const options = (0, _react.useMemo)(() => {
    return [...tags.map(tag => ({
      label: tag.name,
      color: tag.color,
      value: tag
    })), ...(allowCreate ? [createTagOption] : [])];
  }, [allowCreate, tags, createTagOption]);
  const selectedOptions = (0, _react.useMemo)(() => {
    return options.filter(option => isTagOption(option) && selected.includes(option.value.id));
  }, [selected, options]);
  const onChange = (0, _react.useCallback)(newSelectedOptions => {
    // when clicking on the 'create' option, it is selected.
    // we need to remove it from the selection and then open the
    // create modal instead.
    const tagOptions = newSelectedOptions.filter(isTagOption);
    const selectedIds = tagOptions.map(option => option.value.id);
    onTagsSelected(selectedIds);
    if (newSelectedOptions.find(isCreateOption)) {
      openCreateModal({
        defaultValues: {
          name: currentSearch
        },
        onCreate: tag => {
          onTagsSelected([...selected, tag.id]);
        }
      });
    }
  }, [selected, onTagsSelected, openCreateModal, currentSearch]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
    placeholder: '',
    options: options,
    selectedOptions: selectedOptions,
    onSearchChange: setCurrentSearch,
    onChange: onChange,
    renderOption: renderOption,
    fullWidth: fullWidth
  }, otherProps));
};
exports.TagSelector = TagSelector;