"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SAVE_DUPLICATE_REJECTED = exports.OVERWRITE_REJECTED = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * An error message to be used when the user rejects a confirm overwrite.
 * @type {string}
 */
const OVERWRITE_REJECTED = _i18n.i18n.translate('savedObjects.overwriteRejectedDescription', {
  defaultMessage: 'Overwrite confirmation was rejected'
});
/**
 * An error message to be used when the user rejects a confirm save with duplicate title.
 * @type {string}
 */
exports.OVERWRITE_REJECTED = OVERWRITE_REJECTED;
const SAVE_DUPLICATE_REJECTED = _i18n.i18n.translate('savedObjects.saveDuplicateRejectedDescription', {
  defaultMessage: 'Save with duplicate title confirmation was rejected'
});
exports.SAVE_DUPLICATE_REJECTED = SAVE_DUPLICATE_REJECTED;