"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectsManagementPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _services = require("./services");
var _lib = require("./lib");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
class SavedObjectsManagementPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "actionService", new _services.SavedObjectsManagementActionService());
    (0, _defineProperty2.default)(this, "columnService", new _services.SavedObjectsManagementColumnService());
  }
  setup(core, {
    home,
    management
  }) {
    const actionSetup = this.actionService.setup();
    const columnSetup = this.columnService.setup();
    if (home) {
      home.featureCatalogue.register({
        id: 'saved_objects',
        title: _i18n.i18n.translate('savedObjectsManagement.objects.savedObjectsTitle', {
          defaultMessage: 'Saved Objects'
        }),
        description: _i18n.i18n.translate('savedObjectsManagement.objects.savedObjectsDescription', {
          defaultMessage: 'Import, export, and manage your saved objects.'
        }),
        icon: 'savedObjectsApp',
        path: '/app/management/kibana/objects',
        showOnHomePage: false,
        category: 'admin'
      });
    }
    const kibanaSection = management.sections.section.kibana;
    kibanaSection.registerApp({
      id: 'objects',
      title: _i18n.i18n.translate('savedObjectsManagement.managementSectionLabel', {
        defaultMessage: 'Saved Objects'
      }),
      order: 1,
      mount: async mountParams => {
        const {
          mountManagementSection
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./management_section')));
        return mountManagementSection({
          core,
          mountParams
        });
      }
    });
    return {
      actions: actionSetup,
      columns: columnSetup
    };
  }
  start(_core, {
    spaces: spacesApi
  }) {
    const actionStart = this.actionService.start(spacesApi);
    const columnStart = this.columnService.start(spacesApi);
    return {
      actions: actionStart,
      columns: columnStart,
      getAllowedTypes: () => (0, _lib.getAllowedTypes)(_core.http),
      getRelationships: (type, id, savedObjectTypes) => (0, _lib.getRelationships)(_core.http, type, id, savedObjectTypes),
      getSavedObjectLabel: _lib.getSavedObjectLabel,
      getDefaultTitle: _lib.getDefaultTitle,
      parseQuery: _lib.parseQuery,
      getTagFindReferences: _lib.getTagFindReferences
    };
  }
}
exports.SavedObjectsManagementPlugin = SavedObjectsManagementPlugin;