"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotFoundErrors = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const savedObjectsApisLinkText = _i18n.i18n.translate('savedObjectsManagement.view.howToFixErrorDescriptionLinkText', {
  defaultMessage: 'Saved objects APIs'
});
const NotFoundErrors = ({
  type,
  docLinks
}) => {
  const getMessage = () => {
    switch (type) {
      case 'search':
        return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "savedObjectsManagement.view.savedSearchDoesNotExistErrorMessage",
          defaultMessage: "The saved search associated with this object no longer exists."
        });
      case 'index-pattern':
        return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "savedObjectsManagement.view.indexPatternDoesNotExistErrorMessage",
          defaultMessage: "The data view associated with this object no longer exists."
        });
      case 'index-pattern-field':
        return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "savedObjectsManagement.view.fieldDoesNotExistErrorMessage",
          defaultMessage: "A field associated with this object no longer exists in the data view."
        });
      default:
        return null;
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "savedObjectsManagement.view.savedObjectProblemErrorMessage",
      defaultMessage: "There is a problem with this saved object"
    }),
    iconType: "warning",
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement("div", null, getMessage()), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.view.howToFixErrorDescription",
    defaultMessage: "If you know what this error means, you can use the {savedObjectsApis} to fix it \u2014 otherwise click the delete button above.",
    values: {
      savedObjectsApis: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "aria-label": savedObjectsApisLinkText,
        href: `${docLinks.management.savedObjectsApiList}`,
        target: "_blank"
      }, savedObjectsApisLinkText)
    }
  })));
};
exports.NotFoundErrors = NotFoundErrors;