"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobList = void 0;
var _reactRedux = require("react-redux");
var _selectors = require("../../store/selectors");
var _actions = require("../../store/actions");
var _job_list = require("./job_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapStateToProps = state => {
  return {
    hasJobs: Boolean((0, _selectors.getJobsList)(state).length),
    isLoading: (0, _selectors.isLoading)(state),
    jobLoadError: (0, _selectors.jobLoadError)(state)
  };
};
const mapDispatchToProps = dispatch => {
  return {
    loadJobs: () => {
      dispatch((0, _actions.loadJobs)());
    },
    refreshJobs: options => {
      dispatch((0, _actions.refreshJobs)(options));
    },
    openDetailPanel: jobId => {
      dispatch((0, _actions.openDetailPanel)({
        jobId: jobId
      }));
    },
    closeDetailPanel: () => {
      dispatch((0, _actions.closeDetailPanel)());
    },
    cloneJob: jobConfig => {
      dispatch((0, _actions.cloneJob)(jobConfig));
    }
  };
};
const JobList = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_job_list.JobList);
exports.JobList = JobList;