"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepReview = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _services = require("../../../services");
var _components = require("../../components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JOB_DETAILS_TABS = [_components.JOB_DETAILS_TAB_SUMMARY, _components.JOB_DETAILS_TAB_TERMS, _components.JOB_DETAILS_TAB_HISTOGRAM, _components.JOB_DETAILS_TAB_METRICS, _components.JOB_DETAILS_TAB_REQUEST];
class StepReview extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "selectTab", tab => {
      this.setState({
        selectedTab: tab
      });
    });
    this.state = {
      selectedTab: JOB_DETAILS_TABS[0]
    };
  }
  renderTabs() {
    const {
      selectedTab
    } = this.state;
    const {
      job
    } = this.props;
    const renderedTabs = [];
    JOB_DETAILS_TABS.forEach((tab, index) => {
      if (tab === _components.JOB_DETAILS_TAB_TERMS && !job.terms.length) {
        return;
      }
      if (tab === _components.JOB_DETAILS_TAB_HISTOGRAM && !job.histogram.length) {
        return;
      }
      if (tab === _components.JOB_DETAILS_TAB_METRICS && !job.metrics.length) {
        return;
      }
      const isSelected = tab === selectedTab;
      renderedTabs.push( /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
        onClick: () => this.selectTab(tab),
        isSelected: isSelected,
        "data-test-subj": "stepReviewTab",
        key: index
      }, _components.tabToHumanizedMap[tab]));
    });
    if (!renderedTabs.length === 1) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, renderedTabs), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }));
  }
  render() {
    const {
      job
    } = this.props;
    const {
      selectedTab
    } = this.state;
    const json = (0, _services.serializeJob)(job);
    const endpoint = `PUT _rollup/job/${job.id}`;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      "data-test-subj": "rollupJobCreateReviewTitle"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.stepReviewTitle",
      defaultMessage: "Review details for '{jobId}'",
      values: {
        jobId: job.id
      }
    }))), this.renderTabs(), /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_components.JobDetails, {
      job: job,
      json: json,
      endpoint: endpoint,
      tab: selectedTab
    })));
  }
}
exports.StepReview = StepReview;
(0, _defineProperty2.default)(StepReview, "propTypes", {
  job: _propTypes.default.object.isRequired
});