"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reportingScreenshotShareProvider = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _job_utils = require("../../common/job_utils");
var _license_check = require("../lib/license_check");
var _screen_capture_panel_content_lazy = require("./screen_capture_panel_content_lazy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getJobParams = (apiClient, opts, type) => () => {
  const {
    objectType,
    sharingData: {
      title,
      layout,
      locatorParams
    }
  } = opts;
  const baseParams = {
    objectType,
    layout,
    title
  };
  if (type === 'printablePdfV2') {
    // multi locator for PDF V2
    return {
      ...baseParams,
      locatorParams: [locatorParams]
    };
  } else if (type === 'pngV2') {
    // single locator for PNG V2
    return {
      ...baseParams,
      locatorParams
    };
  }

  // Relative URL must have URL prefix (Spaces ID prefix), but not server basePath
  // Replace hashes with original RISON values.
  const relativeUrl = opts.shareableUrl.replace(window.location.origin + apiClient.getServerBasePath(), '');
  if (type === 'printablePdf') {
    // multi URL for PDF
    return {
      ...baseParams,
      relativeUrls: [relativeUrl]
    };
  }

  // single URL for PNG
  return {
    ...baseParams,
    relativeUrl
  };
};
const reportingScreenshotShareProvider = ({
  apiClient,
  toasts,
  uiSettings,
  license,
  application,
  usesUiCapabilities,
  theme
}) => {
  const getShareMenuItems = ({
    objectType,
    objectId,
    isDirty,
    onClose,
    shareableUrl,
    shareableUrlForSavedObject,
    ...shareOpts
  }) => {
    const {
      enableLinks,
      showLinks,
      message
    } = (0, _license_check.checkLicense)(license.check('reporting', 'gold'));
    const licenseToolTipContent = message;
    const licenseHasScreenshotReporting = showLinks;
    const licenseDisabled = !enableLinks;
    let capabilityHasDashboardScreenshotReporting = false;
    let capabilityHasVisualizeScreenshotReporting = false;
    if (usesUiCapabilities) {
      var _application$capabili, _application$capabili2;
      capabilityHasDashboardScreenshotReporting = ((_application$capabili = application.capabilities.dashboard) === null || _application$capabili === void 0 ? void 0 : _application$capabili.generateScreenshot) === true;
      capabilityHasVisualizeScreenshotReporting = ((_application$capabili2 = application.capabilities.visualize) === null || _application$capabili2 === void 0 ? void 0 : _application$capabili2.generateScreenshot) === true;
    } else {
      // deprecated
      capabilityHasDashboardScreenshotReporting = true;
      capabilityHasVisualizeScreenshotReporting = true;
    }
    if (!licenseHasScreenshotReporting) {
      return [];
    }
    const isSupportedType = ['dashboard', 'visualization', 'lens'].includes(objectType);
    if (!isSupportedType) {
      return [];
    }
    if (objectType === 'dashboard' && !capabilityHasDashboardScreenshotReporting) {
      return [];
    }
    if (isSupportedType && !capabilityHasVisualizeScreenshotReporting && !capabilityHasDashboardScreenshotReporting) {
      return [];
    }
    const {
      sharingData
    } = shareOpts;
    const shareActions = [];
    const pngPanelTitle = _i18n.i18n.translate('xpack.reporting.shareContextMenu.pngReportsButtonLabel', {
      defaultMessage: 'PNG Reports'
    });
    const jobProviderOptions = {
      shareableUrl: isDirty ? shareableUrl : shareableUrlForSavedObject !== null && shareableUrlForSavedObject !== void 0 ? shareableUrlForSavedObject : shareableUrl,
      objectType,
      sharingData
    };
    const isV2Job = (0, _job_utils.isJobV2Params)(jobProviderOptions);
    const requiresSavedState = !isV2Job;
    const pngReportType = isV2Job ? 'pngV2' : 'png';
    const panelPng = {
      shareMenuItem: {
        name: pngPanelTitle,
        icon: 'document',
        toolTipContent: licenseToolTipContent,
        disabled: licenseDisabled || sharingData.reportingDisabled,
        ['data-test-subj']: 'PNGReports',
        sortOrder: 10
      },
      panel: {
        id: 'reportingPngPanel',
        title: pngPanelTitle,
        content: /*#__PURE__*/_react.default.createElement(_screen_capture_panel_content_lazy.ScreenCapturePanelContent, {
          apiClient: apiClient,
          toasts: toasts,
          uiSettings: uiSettings,
          reportType: pngReportType,
          objectId: objectId,
          requiresSavedState: requiresSavedState,
          getJobParams: getJobParams(apiClient, jobProviderOptions, pngReportType),
          isDirty: isDirty,
          onClose: onClose,
          theme: theme
        })
      }
    };
    const pdfPanelTitle = _i18n.i18n.translate('xpack.reporting.shareContextMenu.pdfReportsButtonLabel', {
      defaultMessage: 'PDF Reports'
    });
    const pdfReportType = isV2Job ? 'printablePdfV2' : 'printablePdf';
    const panelPdf = {
      shareMenuItem: {
        name: pdfPanelTitle,
        icon: 'document',
        toolTipContent: licenseToolTipContent,
        disabled: licenseDisabled || sharingData.reportingDisabled,
        ['data-test-subj']: 'PDFReports',
        sortOrder: 10
      },
      panel: {
        id: 'reportingPdfPanel',
        title: pdfPanelTitle,
        content: /*#__PURE__*/_react.default.createElement(_screen_capture_panel_content_lazy.ScreenCapturePanelContent, {
          apiClient: apiClient,
          toasts: toasts,
          uiSettings: uiSettings,
          reportType: pdfReportType,
          objectId: objectId,
          requiresSavedState: requiresSavedState,
          layoutOption: objectType === 'dashboard' ? 'print' : undefined,
          getJobParams: getJobParams(apiClient, jobProviderOptions, pdfReportType),
          isDirty: isDirty,
          onClose: onClose,
          theme: theme
        })
      }
    };
    shareActions.push(panelPng);
    shareActions.push(panelPdf);
    return shareActions;
  };
  return {
    id: 'screenCaptureReports',
    getShareMenuItems
  };
};
exports.reportingScreenshotShareProvider = reportingScreenshotShareProvider;