"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCheckIlmPolicyStatus = void 0;
var _constants = require("../../../common/constants");
var _shared_imports = require("../../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCheckIlmPolicyStatus = () => {
  const {
    services: {
      http
    }
  } = (0, _shared_imports.useKibana)();
  return (0, _shared_imports.useRequest)(http, {
    path: _constants.INTERNAL_ROUTES.MIGRATE.GET_ILM_POLICY_STATUS,
    method: 'get'
  });
};
exports.useCheckIlmPolicyStatus = useCheckIlmPolicyStatus;