"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getQueryFromCsvJob = void 0;
var _reportingCommon = require("@kbn/reporting-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Type to wrap the untyped object returned when
 * getting the query from SearchSource service
 */

/**
 * @internal
 */

/**
 * A utility to get the query from a CSV reporting job to inspect or analyze
 * @public
 */
const getQueryFromCsvJob = (searchSource, {
  scroll: config
}, pitId) => {
  // Max number of documents in each returned page
  searchSource.setField('size', (0, _reportingCommon.durationToNumber)(config.size));

  // Max time to wait for result
  searchSource.setField('timeout', config.duration);

  // Request high accuracy for calculating total hits
  searchSource.setField('trackTotalHits', true);
  if (pitId) {
    // Always use most recently provided PIT
    searchSource.setField('pit', {
      id: pitId,
      keep_alive: config.duration
    });
  }
  return {
    requestBody: searchSource.getSearchRequestBody()
  };
};
exports.getQueryFromCsvJob = getQueryFromCsvJob;