"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addCluster = addCluster;
exports.editCluster = editCluster;
exports.loadClusters = loadClusters;
exports.removeClusterRequest = removeClusterRequest;
var _constants = require("../constants");
var _ui_metric = require("./ui_metric");
var _http = require("./http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function loadClusters(options) {
  return await (0, _http.sendGet)(undefined, options);
}
async function addCluster(cluster) {
  const request = (0, _http.sendPost)('', cluster);
  return await (0, _ui_metric.trackUserRequest)(request, _constants.UIM_CLUSTER_ADD);
}
async function editCluster(cluster) {
  const {
    name,
    ...rest
  } = cluster;
  const request = (0, _http.sendPut)(name, rest);
  return await (0, _ui_metric.trackUserRequest)(request, _constants.UIM_CLUSTER_UPDATE);
}
function removeClusterRequest(name) {
  return (0, _http.sendDelete)(name);
}