"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProxyConnection = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _app_context = require("../../../../app_context");
var _documentation = require("../../../../services/documentation");
var _cloud_url_help = require("./cloud_url_help");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProxyConnection = props => {
  const {
    fields,
    fieldsErrors,
    areErrorsVisible,
    onFieldsChange
  } = props;
  const {
    isCloudEnabled
  } = (0, _app_context.useAppContext)();
  const {
    proxyAddress,
    serverName,
    proxySocketConnections,
    cloudUrl,
    cloudUrlEnabled
  } = fields;
  const {
    proxyAddress: proxyAddressError,
    serverName: serverNameError,
    cloudUrl: cloudUrlError
  } = fieldsErrors;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, cloudUrlEnabled ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "remoteClusterFormCloudUrlFormRow",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldCloudUrlLabel",
      defaultMessage: "Elasticsearch endpoint URL"
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_cloud_url_help.CloudUrlHelp, null),
    isInvalid: Boolean(areErrorsVisible && cloudUrlError),
    error: cloudUrlError,
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldCloudUrlHelpText",
      defaultMessage: "The protocol (https://) and port values are optional."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: cloudUrl,
    onChange: e => onFieldsChange({
      cloudUrl: e.target.value
    }),
    isInvalid: Boolean(areErrorsVisible && cloudUrlError),
    "data-test-subj": "remoteClusterFormCloudUrlInput",
    fullWidth: true
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "remoteClusterFormProxyAddressFormRow",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldProxyAddressLabel",
      defaultMessage: "Proxy address"
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldProxyAddressHelpText",
      defaultMessage: "The address to use for remote connections."
    }),
    isInvalid: Boolean(areErrorsVisible && proxyAddressError),
    error: proxyAddressError,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: proxyAddress,
    placeholder: _i18n.i18n.translate('xpack.remoteClusters.remoteClusterForm.fieldProxyAddressPlaceholder', {
      defaultMessage: 'host:port'
    }),
    onChange: e => onFieldsChange({
      proxyAddress: e.target.value
    }),
    isInvalid: Boolean(areErrorsVisible && proxyAddressError),
    "data-test-subj": "remoteClusterFormProxyAddressInput",
    fullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "remoteClusterFormServerNameFormRow",
    isInvalid: Boolean(areErrorsVisible && serverNameError),
    error: serverNameError,
    label: isCloudEnabled ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldServerNameRequiredLabel",
      defaultMessage: "Server name"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldServerNameOptionalLabel",
      defaultMessage: "Server name (optional)"
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldServerNameHelpText",
      defaultMessage: "A string sent in the server_name field of the TLS Server Name Indication extension if TLS is enabled. {learnMoreLink}",
      values: {
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation.proxySettingsUrl,
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.remoteClusters.remoteClusterForm.fieldServerNameHelpText.learnMoreLinkLabel",
          defaultMessage: "Learn more."
        }))
      }
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: serverName,
    onChange: e => onFieldsChange({
      serverName: e.target.value
    }),
    isInvalid: Boolean(areErrorsVisible && serverNameError),
    fullWidth: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "remoteClusterFormProxySocketConnectionsFormRow",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldProxySocketConnectionsLabel",
      defaultMessage: "Socket connections"
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldSocketConnectionsHelpText",
      defaultMessage: "The number of connections to open per remote cluster."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    value: proxySocketConnections || '',
    onChange: e => onFieldsChange({
      proxySocketConnections: Number(e.target.value)
    }),
    fullWidth: true
  })));
};
exports.ProxyConnection = ProxyConnection;