"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _reactRedux = require("react-redux");
var _shared_imports = require("../shared_imports");
var _app = require("./app");
var _store = require("./store");
var _app_context = require("./app_context");
require("./_hacks.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AppWithExecutionContext = ({
  history,
  executionContext
}) => {
  (0, _shared_imports.useExecutionContext)(executionContext, {
    type: 'application',
    page: 'remoteClusters'
  });
  return /*#__PURE__*/_react.default.createElement(_app.App, {
    history: history
  });
};
const renderApp = (elem, I18nContext, appDependencies, history, theme$) => {
  (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(I18nContext, null, /*#__PURE__*/_react.default.createElement(_shared_imports.KibanaThemeProvider, {
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: _store.remoteClustersStore
  }, /*#__PURE__*/_react.default.createElement(_app_context.AppContextProvider, {
    context: appDependencies
  }, /*#__PURE__*/_react.default.createElement(AppWithExecutionContext, {
    history: history,
    executionContext: appDependencies.executionContext
  }))))), elem);
  return () => (0, _reactDom.unmountComponentAtNode)(elem);
};
exports.renderApp = renderApp;