"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostBreakdownChart = HostBreakdownChart;
var _charts = require("@elastic/charts");
var _common = require("@kbn/observability-plugin/common");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _use_kibana_timezone_setting = require("../../../hooks/use_kibana_timezone_setting");
var _use_profiling_charts_theme = require("../../../hooks/use_profiling_charts_theme");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HostBreakdownChart({
  data = []
}) {
  const {
    chartsBaseTheme,
    chartsTheme
  } = (0, _use_profiling_charts_theme.useProfilingChartsTheme)();
  const timeZone = (0, _use_kibana_timezone_setting.useKibanaTimeZoneSetting)();
  const hostBreakdownTimeseries = (0, _react.useMemo)(() => {
    var _data$map;
    return (_data$map = data.map(({
      hostId,
      hostName,
      timeseries
    }) => {
      return {
        data: timeseries !== null && timeseries !== void 0 ? timeseries : [],
        type: 'area',
        title: `${hostName} [${hostId}]`
      };
    })) !== null && _data$map !== void 0 ? _data$map : [];
  }, [data]);
  const xValues = hostBreakdownTimeseries.flatMap(({
    data: timeseriesData
  }) => timeseriesData.map(({
    x
  }) => x));
  const min = Math.min(...xValues);
  const max = Math.max(...xValues);
  const xFormatter = (0, _charts.niceTimeFormatter)([min, max]);
  return /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 400
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    showLegend: true,
    legendPosition: _charts.Position.Right,
    baseTheme: chartsBaseTheme,
    theme: chartsTheme,
    locale: _i18n.i18n.getLocale()
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "x-axis",
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: xFormatter,
    gridLine: {
      visible: false
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "y-axis",
    position: _charts.Position.Left,
    gridLine: {
      visible: true
    },
    tickFormat: _common.asDynamicBytes
  }), hostBreakdownTimeseries.map(serie => /*#__PURE__*/_react.default.createElement(_charts.AreaSeries, {
    timeZone: timeZone,
    key: serie.title,
    id: serie.title,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "x",
    yAccessors: ['y'],
    data: serie.data,
    stackAccessors: ['x']
  })));
}