"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopNFunctionsView = TopNFunctionsView;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _async_component = require("../../../components/async_component");
var _use_profiling_dependencies = require("../../../components/contexts/profiling_dependencies/use_profiling_dependencies");
var _topn_functions = require("../../../components/topn_functions");
var _use_profiling_params = require("../../../hooks/use_profiling_params");
var _use_profiling_router = require("../../../hooks/use_profiling_router");
var _use_time_range = require("../../../hooks/use_time_range");
var _use_time_range_async = require("../../../hooks/use_time_range_async");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TopNFunctionsView() {
  const {
    query
  } = (0, _use_profiling_params.useProfilingParams)('/functions/topn');
  const {
    rangeFrom,
    rangeTo,
    kuery,
    sortDirection,
    sortField,
    pageIndex = 0
  } = query;
  const timeRange = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    services: {
      fetchTopNFunctions
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const state = (0, _use_time_range_async.useTimeRangeAsync)(({
    http
  }) => {
    return fetchTopNFunctions({
      http,
      timeFrom: new Date(timeRange.start).getTime(),
      timeTo: new Date(timeRange.end).getTime(),
      startIndex: 0,
      endIndex: 100000,
      kuery
    });
  }, [fetchTopNFunctions, timeRange.start, timeRange.end, kuery]);
  const profilingRouter = (0, _use_profiling_router.useProfilingRouter)();
  function handleOnFrameClick(functionName) {
    profilingRouter.push('/flamegraphs/flamegraph', {
      path: {},
      query: {
        ...query,
        searchText: functionName
      }
    });
  }
  function handlePageChange(nextPage) {
    profilingRouter.push('/functions/topn', {
      path: {},
      query: {
        ...query,
        pageIndex: nextPage
      }
    });
  }
  function handleSortChange(sorting) {
    profilingRouter.push('/functions/topn', {
      path: {},
      query: {
        ...query,
        sortField: sorting.id,
        sortDirection: sorting.direction
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_async_component.AsyncComponent, (0, _extends2.default)({}, state, {
    size: "xl",
    alignTop: true
  }), /*#__PURE__*/_react.default.createElement(_topn_functions.TopNFunctionsGrid, {
    topNFunctions: state.data,
    totalSeconds: timeRange.inSeconds.end - timeRange.inSeconds.start,
    isDifferentialView: false,
    onFrameClick: handleOnFrameClick,
    pageIndex: pageIndex,
    onChangePage: handlePageChange,
    sortField: sortField,
    sortDirection: sortDirection,
    onChangeSort: handleSortChange
  })))))));
}