"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FramesSummary = FramesSummary;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-plugin/common");
var _use_calculate_impact_estimates = require("../../hooks/use_calculate_impact_estimates");
var _as_cost = require("../../utils/formatters/as_cost");
var _as_weight = require("../../utils/formatters/as_weight");
var _utils = require("../topn_functions/utils");
var _summary_item = require("./summary_item");
var _use_profiling_dependencies = require("../contexts/profiling_dependencies/use_profiling_dependencies");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ESTIMATED_VALUE_LABEL = _i18n.i18n.translate('xpack.profiling.diffTopNFunctions.estimatedValue', {
  defaultMessage: 'Estimated value'
});
function getScaleFactor(scaleFactor = 1) {
  return scaleFactor;
}
function FramesSummary({
  baseValue,
  comparisonValue,
  isLoading
}) {
  const {
    start: {
      core
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const shouldUseLegacyCo2Calculation = core.uiSettings.get(_common.profilingUseLegacyCo2Calculation);
  const calculateImpactEstimates = (0, _use_calculate_impact_estimates.useCalculateImpactEstimate)();
  const baselineScaledTotalSamples = baseValue ? baseValue.totalCount * getScaleFactor(baseValue.scaleFactor) : 0;
  const comparisonScaledTotalSamples = comparisonValue ? comparisonValue.totalCount * getScaleFactor(comparisonValue.scaleFactor) : 0;
  const {
    co2EmissionDiff,
    costImpactDiff,
    totalSamplesDiff
  } = (0, _react.useMemo)(() => {
    var _baseImpactEstimates$;
    const baseImpactEstimates = baseValue ?
    // Do NOT scale values here. This is intended to show the exact values spent throughout the year
    calculateImpactEstimates({
      countExclusive: baseValue.selfCPU,
      countInclusive: baseValue.totalCPU,
      totalSamples: baseValue.totalCount,
      totalSeconds: baseValue.duration
    }) : undefined;
    const comparisonImpactEstimates = comparisonValue ?
    // Do NOT scale values here. This is intended to show the exact values spent throughout the year
    calculateImpactEstimates({
      countExclusive: comparisonValue.selfCPU,
      countInclusive: comparisonValue.totalCPU,
      totalSamples: comparisonValue.totalCount,
      totalSeconds: comparisonValue.duration
    }) : undefined;
    return {
      totalSamplesDiff: (0, _utils.calculateBaseComparisonDiff)({
        baselineValue: baselineScaledTotalSamples || 0,
        comparisonValue: comparisonScaledTotalSamples || 0
      }),
      co2EmissionDiff: (0, _utils.calculateBaseComparisonDiff)({
        baselineValue: (shouldUseLegacyCo2Calculation ? baseImpactEstimates === null || baseImpactEstimates === void 0 ? void 0 : (_baseImpactEstimates$ = baseImpactEstimates.totalSamples) === null || _baseImpactEstimates$ === void 0 ? void 0 : _baseImpactEstimates$.annualizedCo2 : baseValue === null || baseValue === void 0 ? void 0 : baseValue.totalAnnualCO2Kgs) || 0,
        comparisonValue: (shouldUseLegacyCo2Calculation ? comparisonImpactEstimates === null || comparisonImpactEstimates === void 0 ? void 0 : comparisonImpactEstimates.totalSamples.annualizedCo2 : comparisonValue === null || comparisonValue === void 0 ? void 0 : comparisonValue.totalAnnualCO2Kgs) || 0,
        formatValue: value => (0, _as_weight.asWeight)(value, 'kgs')
      }),
      costImpactDiff: (0, _utils.calculateBaseComparisonDiff)({
        baselineValue: (shouldUseLegacyCo2Calculation ? baseImpactEstimates === null || baseImpactEstimates === void 0 ? void 0 : baseImpactEstimates.totalSamples.annualizedDollarCost : baseValue === null || baseValue === void 0 ? void 0 : baseValue.totalAnnualCostUSD) || 0,
        comparisonValue: (shouldUseLegacyCo2Calculation ? comparisonImpactEstimates === null || comparisonImpactEstimates === void 0 ? void 0 : comparisonImpactEstimates.totalSamples.annualizedDollarCost : comparisonValue === null || comparisonValue === void 0 ? void 0 : comparisonValue.totalAnnualCostUSD) || 0,
        formatValue: _as_cost.asCost
      })
    };
  }, [baseValue, baselineScaledTotalSamples, calculateImpactEstimates, comparisonScaledTotalSamples, comparisonValue, shouldUseLegacyCo2Calculation]);
  const data = [{
    id: 'overallPerformance',
    title: _i18n.i18n.translate('xpack.profiling.diffTopNFunctions.summary.performance', {
      defaultMessage: '{label} overall performance by',
      values: {
        label: isLoading || totalSamplesDiff.percentDiffDelta === undefined || totalSamplesDiff.label === undefined ? 'Gained/Lost' : (totalSamplesDiff === null || totalSamplesDiff === void 0 ? void 0 : totalSamplesDiff.percentDiffDelta) > 0 ? 'Lost' : 'Gained'
      }
    }),
    baseValue: totalSamplesDiff.label || '0%',
    baseIcon: totalSamplesDiff.icon,
    baseColor: totalSamplesDiff.color,
    titleHint: ESTIMATED_VALUE_LABEL
  }, {
    id: 'annualizedCo2',
    title: _i18n.i18n.translate('xpack.profiling.diffTopNFunctions.summary.co2', {
      defaultMessage: 'Annualized CO2 emission impact'
    }),
    baseValue: co2EmissionDiff.baseValue,
    comparisonValue: co2EmissionDiff.comparisonValue,
    comparisonIcon: co2EmissionDiff.icon,
    comparisonColor: co2EmissionDiff.color,
    comparisonPerc: co2EmissionDiff.label,
    titleHint: ESTIMATED_VALUE_LABEL
  }, {
    id: 'annualizedCost',
    title: _i18n.i18n.translate('xpack.profiling.diffTopNFunctions.summary.cost', {
      defaultMessage: 'Annualized cost impact'
    }),
    baseValue: costImpactDiff.baseValue,
    comparisonValue: costImpactDiff.comparisonValue,
    comparisonIcon: costImpactDiff.icon,
    comparisonColor: costImpactDiff.color,
    comparisonPerc: costImpactDiff.label,
    titleHint: ESTIMATED_VALUE_LABEL
  }, {
    id: 'totalNumberOfSamples',
    title: _i18n.i18n.translate('xpack.profiling.diffTopNFunctions.summary.samples', {
      defaultMessage: 'Total number of samples'
    }),
    baseValue: totalSamplesDiff.baseValue,
    comparisonValue: totalSamplesDiff.comparisonValue,
    comparisonIcon: totalSamplesDiff.icon,
    comparisonColor: totalSamplesDiff.color,
    comparisonPerc: totalSamplesDiff.label,
    titleHint: ESTIMATED_VALUE_LABEL
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    initialIsOpen: true,
    id: "TopNFunctionsSummary",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: data[0].baseColor,
      style: {
        fontWeight: 'bold'
      },
      textAlign: "left"
    }, data[0].title)), data[0].baseIcon && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      style: {
        justifyContent: 'center'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: data[0].baseIcon,
      color: data[0].baseColor,
      size: "s"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      style: {
        fontWeight: 'bold'
      },
      color: data[0].baseColor
    }, data[0].baseValue)))
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, data.map((item, idx) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: idx
    }, /*#__PURE__*/_react.default.createElement(_summary_item.SummaryItem, (0, _extends2.default)({}, item, {
      isLoading: isLoading
    })));
  }))));
}