"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSetupState = createSetupState;
exports.getSetupState = getSetupState;
var _common = require("@kbn/spaces-plugin/common");
var _cloud_setup_state = require("./cloud_setup_state");
var _self_managed_setup_state = require("./self_managed_setup_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getSetupState({
  createProfilingEsClient,
  deps,
  esClient,
  logger,
  soClient,
  spaceId
}) {
  var _deps$cloud;
  const kibanaInternalProfilingESClient = createProfilingEsClient({
    esClient: esClient.asInternalUser,
    useDefaultAuth: false
  });
  const profilingESClient = createProfilingEsClient({
    esClient: esClient.asCurrentUser,
    useDefaultAuth: false
  });
  const isCloudEnabled = (_deps$cloud = deps.cloud) === null || _deps$cloud === void 0 ? void 0 : _deps$cloud.isCloudEnabled;
  if (isCloudEnabled) {
    if (!deps.fleet) {
      throw new Error('Elastic Fleet is required to set up Universal Profiling on Cloud');
    }
    const setupState = await (0, _cloud_setup_state.cloudSetupState)({
      client: kibanaInternalProfilingESClient,
      clientWithProfilingAuth: profilingESClient,
      logger,
      soClient,
      spaceId: spaceId !== null && spaceId !== void 0 ? spaceId : _common.DEFAULT_SPACE_ID,
      packagePolicyClient: deps.fleet.packagePolicyService,
      isCloudEnabled
    });
    return {
      type: 'cloud',
      setupState
    };
  }
  const setupState = await (0, _self_managed_setup_state.selfManagedSetupState)({
    client: kibanaInternalProfilingESClient,
    clientWithProfilingAuth: profilingESClient,
    logger,
    soClient,
    spaceId: spaceId !== null && spaceId !== void 0 ? spaceId : _common.DEFAULT_SPACE_ID
  });
  return {
    type: 'self-managed',
    setupState
  };
}
function createSetupState(params) {
  return async ({
    esClient,
    soClient,
    spaceId
  }) => getSetupState({
    ...params,
    esClient,
    soClient,
    spaceId
  });
}