"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registry = exports.providers = exports.pluginServices = void 0;
var _create = require("./create");
var _capabilities_service = require("./capabilities/capabilities_service");
var _data_views_service = require("./data_views/data_views_service");
var _content_management_service = require("./content_management/content_management_service");
var _ui_actions_service = require("./ui_actions/ui_actions_service");
var _labs_service = require("./labs/labs_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const providers = {
  capabilities: new _create.PluginServiceProvider(_capabilities_service.capabilitiesServiceFactory),
  labs: new _create.PluginServiceProvider(_labs_service.labsServiceFactory),
  dataViews: new _create.PluginServiceProvider(_data_views_service.dataViewsServiceFactory),
  uiActions: new _create.PluginServiceProvider(_ui_actions_service.uiActionsServiceFactory),
  contentManagement: new _create.PluginServiceProvider(_content_management_service.contentManagementServiceFactory)
};
exports.providers = providers;
const pluginServices = new _create.PluginServices();
exports.pluginServices = pluginServices;
const registry = new _create.PluginServiceRegistry(providers);
exports.registry = registry;