"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FloatingActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _public = require("@kbn/embeddable-plugin/public");
var _services = require("../../services");
require("./floating_actions.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const FloatingActions = ({
  children,
  viewMode,
  isEnabled,
  embeddable,
  className = '',
  disabledActions
}) => {
  const {
    uiActions: {
      getTriggerCompatibleActions
    }
  } = _services.pluginServices.getServices();
  const [floatingActions, setFloatingActions] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    if (!embeddable) return;
    const getActions = async () => {
      const context = {
        embeddable,
        trigger: _public.panelHoverTrigger
      };
      const actions = (await getTriggerCompatibleActions(_public.PANEL_HOVER_TRIGGER, context)).filter(action => {
        return action.MenuItem !== undefined && (disabledActions !== null && disabledActions !== void 0 ? disabledActions : []).indexOf(action.id) === -1;
      }).sort((a, b) => (a.order || 0) - (b.order || 0));
      if (actions.length > 0) {
        setFloatingActions( /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, actions.map(action => /*#__PURE__*/_react.default.createElement(action.MenuItem, {
          key: action.id,
          context
        }))));
      } else {
        setFloatingActions(undefined);
      }
    };
    getActions();
  }, [embeddable, getTriggerCompatibleActions, viewMode, disabledActions]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "presentationUtil__floatingActionsWrapper"
  }, children, isEnabled && floatingActions && /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('presentationUtil__floatingActions', className)
  }, floatingActions));
};
exports.FloatingActions = FloatingActions;