"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.readSavedQueryRoute = void 0;
var _route_validation = require("../../utils/build_validation/route_validation");
var _constants = require("../../../common/constants");
var _utils = require("./utils");
var _common = require("../../../common");
var _types = require("../../../common/types");
var _utils2 = require("../utils");
var _read_saved_query_route = require("../../../common/api/saved_query/read_saved_query_route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const readSavedQueryRoute = (router, osqueryContext) => {
  router.versioned.get({
    access: 'public',
    path: '/api/osquery/saved_queries/{id}',
    options: {
      tags: [`access:${_common.PLUGIN_ID}-readSavedQueries`]
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: {
        params: (0, _route_validation.buildRouteValidation)(_read_saved_query_route.readSavedQueryRequestParamsSchema)
      }
    }
  }, async (context, request, response) => {
    var _osqueryContext$servi;
    const coreContext = await context.core;
    const savedObjectsClient = coreContext.savedObjects.client;
    const savedQuery = await savedObjectsClient.get(_types.savedQuerySavedObjectType, request.params.id);
    if (savedQuery.attributes.ecs_mapping) {
      // @ts-expect-error update types
      savedQuery.attributes.ecs_mapping = (0, _utils2.convertECSMappingToObject)(savedQuery.attributes.ecs_mapping);
    }
    savedQuery.attributes.prebuilt = await (0, _utils.isSavedQueryPrebuilt)((_osqueryContext$servi = osqueryContext.service.getPackageService()) === null || _osqueryContext$servi === void 0 ? void 0 : _osqueryContext$servi.asInternalUser, savedQuery.id);
    const {
      created_at: createdAt,
      created_by: createdBy,
      description,
      id,
      interval,
      timeout,
      platform,
      query,
      removed,
      snapshot,
      version,
      ecs_mapping: ecsMapping,
      updated_at: updatedAt,
      updated_by: updatedBy,
      prebuilt
    } = savedQuery.attributes;
    const data = {
      created_at: createdAt,
      created_by: createdBy,
      description,
      id,
      removed,
      snapshot,
      version,
      ecs_mapping: ecsMapping,
      interval,
      timeout,
      platform,
      query,
      updated_at: updatedAt,
      updated_by: updatedBy,
      prebuilt,
      saved_object_id: savedQuery.id
    };
    return response.ok({
      body: {
        data
      }
    });
  });
};
exports.readSavedQueryRoute = readSavedQueryRoute;