"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteSavedQueryRoute = void 0;
var _route_validation = require("../../utils/build_validation/route_validation");
var _constants = require("../../../common/constants");
var _common = require("../../../common");
var _types = require("../../../common/types");
var _utils = require("./utils");
var _delete_saved_query_route = require("../../../common/api/saved_query/delete_saved_query_route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteSavedQueryRoute = (router, osqueryContext) => {
  router.versioned.delete({
    access: 'public',
    path: '/api/osquery/saved_queries/{id}',
    options: {
      tags: [`access:${_common.PLUGIN_ID}-writeSavedQueries`]
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: {
        params: (0, _route_validation.buildRouteValidation)(_delete_saved_query_route.deleteSavedQueryRequestParamsSchema)
      }
    }
  }, async (context, request, response) => {
    var _osqueryContext$servi;
    const coreContext = await context.core;
    const savedObjectsClient = coreContext.savedObjects.client;
    const isPrebuilt = await (0, _utils.isSavedQueryPrebuilt)((_osqueryContext$servi = osqueryContext.service.getPackageService()) === null || _osqueryContext$servi === void 0 ? void 0 : _osqueryContext$servi.asInternalUser, request.params.id);
    if (isPrebuilt) {
      return response.conflict({
        body: `Elastic prebuilt Saved query cannot be deleted.`
      });
    }
    await savedObjectsClient.delete(_types.savedQuerySavedObjectType, request.params.id, {
      refresh: 'wait_for'
    });
    return response.ok({
      body: {}
    });
  });
};
exports.deleteSavedQueryRoute = deleteSavedQueryRoute;