"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAgentStatusForAgentPolicyRoute = void 0;
var _route_validation = require("../../utils/build_validation/route_validation");
var _constants = require("../../../common/constants");
var _common = require("../../../common");
var _api = require("../../../common/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAgentStatusForAgentPolicyRoute = (router, osqueryContext) => {
  router.versioned.get({
    access: 'internal',
    path: '/internal/osquery/fleet_wrapper/agent_status',
    options: {
      tags: [`access:${_common.PLUGIN_ID}-read`]
    }
  }).addVersion({
    version: _constants.API_VERSIONS.internal.v1,
    validate: {
      request: {
        params: (0, _route_validation.buildRouteValidation)(_api.getAgentStatusForAgentPolicyRequestParamsSchema),
        query: (0, _route_validation.buildRouteValidation)(_api.getAgentStatusForAgentPolicyRequestQuerySchema)
      }
    }
  }, async (context, request, response) => {
    var _osqueryContext$servi;
    const results = await ((_osqueryContext$servi = osqueryContext.service.getAgentService()) === null || _osqueryContext$servi === void 0 ? void 0 : _osqueryContext$servi.asScoped(request).getAgentStatusForAgentPolicy(request.query.policyId, request.query.kuery));
    if (!results) {
      return response.ok({
        body: {}
      });
    }
    const body = {
      results
    };
    return response.ok({
      body
    });
  });
};
exports.getAgentStatusForAgentPolicyRoute = getAgentStatusForAgentPolicyRoute;