"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateGlobalPacksCreateCallback = void 0;
var _saferLodashSet = require("@kbn/safer-lodash-set");
var _lodash = require("lodash");
var _common = require("@kbn/fleet-plugin/common");
var _immer = _interopRequireDefault(require("immer"));
var _utils = require("../routes/utils");
var _types = require("../../common/types");
var _utils2 = require("../routes/pack/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateGlobalPacksCreateCallback = async (packagePolicy, packsClient, allPacks, osqueryContext) => {
  const agentPolicyService = osqueryContext.getAgentPolicyService();
  const agentPoliciesResult = await (agentPolicyService === null || agentPolicyService === void 0 ? void 0 : agentPolicyService.getByIds(packsClient, [packagePolicy.policy_id]));
  const agentPolicyResultIds = (0, _lodash.map)(agentPoliciesResult, 'id');
  const agentPolicies = agentPoliciesResult ? (0, _lodash.mapKeys)(await (agentPolicyService === null || agentPolicyService === void 0 ? void 0 : agentPolicyService.getByIds(packsClient, agentPolicyResultIds)), 'id') : {};
  const packsContainingShardForPolicy = [];
  allPacks.map(pack => {
    const shards = (0, _utils.convertShardsToObject)(pack.shards);
    return (0, _lodash.map)(shards, (shard, shardName) => {
      if (shardName === '*') {
        packsContainingShardForPolicy.push(pack);
      }
    });
  });
  if (packsContainingShardForPolicy.length) {
    await Promise.all((0, _lodash.map)(packsContainingShardForPolicy, pack => {
      var _pack$references, _agentPolicies$packag;
      packsClient.update(_types.packSavedObjectType, pack.saved_object_id, {}, {
        references: [...((_pack$references = pack.references) !== null && _pack$references !== void 0 ? _pack$references : []), {
          id: packagePolicy.policy_id,
          name: (_agentPolicies$packag = agentPolicies[packagePolicy.policy_id]) === null || _agentPolicies$packag === void 0 ? void 0 : _agentPolicies$packag.name,
          type: _common.AGENT_POLICY_SAVED_OBJECT_TYPE
        }]
      });
    }));
    return (0, _immer.default)(packagePolicy, draft => {
      if (!(0, _lodash.has)(draft, 'inputs[0].streams')) {
        (0, _saferLodashSet.set)(draft, 'inputs[0].streams', []);
      }
      (0, _lodash.map)(packsContainingShardForPolicy, pack => {
        (0, _saferLodashSet.set)(draft, `inputs[0].config.osquery.value.packs.${pack.name}`, {
          shard: 100,
          queries: (0, _utils2.convertSOQueriesToPackConfig)(pack.queries)
        });
      });
      return draft;
    });
  }
  return packagePolicy;
};
exports.updateGlobalPacksCreateCallback = updateGlobalPacksCreateCallback;