"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueriesPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactRouterDom = require("react-router-dom");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _constants = require("../../../../common/constants");
var _search_strategy = require("../../../../common/search_strategy");
var _layouts = require("../../../components/layouts");
var _use_breadcrumbs = require("../../../common/hooks/use_breadcrumbs");
var _kibana = require("../../../common/lib/kibana");
var _use_saved_queries = require("../../../saved_queries/use_saved_queries");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PlayButtonComponent = ({
  disabled = false,
  savedQuery
}) => {
  const {
    push
  } = (0, _reactRouterDom.useHistory)();

  // TODO: Add href
  const handlePlayClick = (0, _react.useCallback)(() => {
    var _savedQuery$timeout;
    return push('/live_queries/new', {
      form: {
        savedQueryId: savedQuery.id,
        query: savedQuery.query,
        ecs_mapping: savedQuery.ecs_mapping,
        timeout: (_savedQuery$timeout = savedQuery.timeout) !== null && _savedQuery$timeout !== void 0 ? _savedQuery$timeout : _constants.QUERY_TIMEOUT.DEFAULT
      }
    });
  }, [push, savedQuery]);
  const playText = (0, _react.useMemo)(() => _i18n.i18n.translate('xpack.osquery.savedQueryList.queriesTable.runActionAriaLabel', {
    defaultMessage: 'Run {savedQueryName}',
    values: {
      savedQueryName: savedQuery.id
    }
  }), [savedQuery]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: playText
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "primary",
    iconType: "play",
    isDisabled: disabled,
    onClick: handlePlayClick,
    "aria-label": playText
  }));
};
const PlayButton = /*#__PURE__*/_react.default.memo(PlayButtonComponent, _fastDeepEqual.default);
const EditButtonComponent = ({
  disabled = false,
  savedQueryId,
  savedQueryName
}) => {
  const buttonProps = (0, _kibana.useRouterNavigate)(`saved_queries/${savedQueryId}`);
  const editText = (0, _react.useMemo)(() => _i18n.i18n.translate('xpack.osquery.savedQueryList.queriesTable.editActionAriaLabel', {
    defaultMessage: 'Edit {savedQueryName}',
    values: {
      savedQueryName
    }
  }), [savedQueryName]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: editText
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    color: "primary"
  }, buttonProps, {
    iconType: "pencil",
    isDisabled: disabled,
    "aria-label": editText
  })));
};
const EditButton = /*#__PURE__*/_react.default.memo(EditButtonComponent);
const SavedQueriesPageComponent = () => {
  const permissions = (0, _kibana.useKibana)().services.application.capabilities.osquery;
  (0, _use_breadcrumbs.useBreadcrumbs)('saved_queries');
  const newQueryLinkProps = (0, _kibana.useRouterNavigate)('saved_queries/new');
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(20);
  const [sortField, setSortField] = (0, _react.useState)('updated_at');
  const [sortDirection, setSortDirection] = (0, _react.useState)(_search_strategy.Direction.desc);
  const {
    data
  } = (0, _use_saved_queries.useSavedQueries)({
    isLive: true
  });
  const renderEditAction = (0, _react.useCallback)(item => /*#__PURE__*/_react.default.createElement(EditButton, {
    savedQueryId: item.saved_object_id,
    savedQueryName: item.id
  }), []);
  const renderPlayAction = (0, _react.useCallback)(item => permissions.runSavedQueries || permissions.writeLiveQueries ? /*#__PURE__*/_react.default.createElement(PlayButton, {
    savedQuery: item,
    disabled: false
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null), [permissions.runSavedQueries, permissions.writeLiveQueries]);
  const renderUpdatedAt = (0, _react.useCallback)((updatedAt, item) => {
    if (!updatedAt) return '-';
    const updatedBy = item.updated_by !== item.created_by ? ` @ ${item.updated_by}` : '';
    return updatedAt ? `${(0, _momentTimezone.default)(updatedAt).fromNow()}${updatedBy}` : '-';
  }, []);
  const renderDescriptionColumn = (0, _react.useCallback)(description => {
    const content = description && description.length > 80 ? `${description === null || description === void 0 ? void 0 : description.substring(0, 80)}...` : description;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, description)
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, content));
  }, []);
  const columns = (0, _react.useMemo)(() => [{
    field: 'id',
    name: _i18n.i18n.translate('xpack.osquery.savedQueries.table.queryIdColumnTitle', {
      defaultMessage: 'Query ID'
    }),
    sortable: item => item.id.toLowerCase(),
    truncateText: true,
    width: '15%'
  }, {
    field: 'description',
    name: _i18n.i18n.translate('xpack.osquery.savedQueries.table.descriptionColumnTitle', {
      defaultMessage: 'Description'
    }),
    render: renderDescriptionColumn,
    width: '50%'
  }, {
    field: 'created_by',
    name: _i18n.i18n.translate('xpack.osquery.savedQueries.table.createdByColumnTitle', {
      defaultMessage: 'Created by'
    }),
    width: '15%',
    sortable: true,
    truncateText: true
  }, {
    field: 'updated_at',
    name: _i18n.i18n.translate('xpack.osquery.savedQueries.table.updatedAtColumnTitle', {
      defaultMessage: 'Last updated at'
    }),
    width: '10%',
    sortable: item => item.updated_at ? Date.parse(item.updated_at) : 0,
    truncateText: true,
    render: renderUpdatedAt
  }, {
    name: _i18n.i18n.translate('xpack.osquery.savedQueries.table.actionsColumnTitle', {
      defaultMessage: 'Actions'
    }),
    actions: [{
      render: renderPlayAction
    }, {
      render: renderEditAction
    }]
  }], [renderDescriptionColumn, renderEditAction, renderPlayAction, renderUpdatedAt]);
  const onTableChange = (0, _react.useCallback)(({
    page = {},
    sort = {}
  }) => {
    setPageIndex(page.index);
    setPageSize(page.size);
    setSortField(sort.field);
    setSortDirection(sort.direction);
  }, []);
  const pagination = (0, _react.useMemo)(() => {
    var _data$total;
    return {
      pageIndex,
      pageSize,
      totalItemCount: (_data$total = data === null || data === void 0 ? void 0 : data.total) !== null && _data$total !== void 0 ? _data$total : 0,
      pageSizeOptions: [10, 20, 50, 100]
    };
  }, [pageIndex, pageSize, data === null || data === void 0 ? void 0 : data.total]);
  const sorting = (0, _react.useMemo)(() => ({
    sort: {
      field: sortField,
      direction: sortDirection
    }
  }), [sortDirection, sortField]);
  const LeftColumn = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.savedQueryList.pageTitle",
    defaultMessage: "Saved queries"
  }))))), []);
  const RightColumn = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    fill: true
  }, newQueryLinkProps, {
    iconType: "plusInCircle",
    isDisabled: !permissions.writeSavedQueries
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.savedQueryList.addSavedQueryButtonLabel",
    defaultMessage: "Add saved query"
  })), [permissions.writeSavedQueries, newQueryLinkProps]);
  return /*#__PURE__*/_react.default.createElement(_layouts.WithHeaderLayout, {
    leftColumn: LeftColumn,
    rightColumn: RightColumn,
    rightColumnGrow: false
  }, (data === null || data === void 0 ? void 0 : data.data) && /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: data === null || data === void 0 ? void 0 : data.data,
    itemId: "id",
    columns: columns,
    pagination: pagination,
    sorting: sorting,
    onChange: onTableChange,
    rowHeader: "id"
  }));
};
const QueriesPage = /*#__PURE__*/_react.default.memo(SavedQueriesPageComponent);
exports.QueriesPage = QueriesPage;