"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedQueries = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _list = require("./list");
var _new = require("./new");
var _edit = require("./edit");
var _use_breadcrumbs = require("../../common/hooks/use_breadcrumbs");
var _components = require("../components");
var _kibana = require("../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SavedQueriesComponent = () => {
  const permissions = (0, _kibana.useKibana)().services.application.capabilities.osquery;
  (0, _use_breadcrumbs.useBreadcrumbs)('saved_queries');
  const match = (0, _reactRouterDom.useRouteMatch)();
  if (!permissions.readSavedQueries) {
    return /*#__PURE__*/_react.default.createElement(_components.MissingPrivileges, null);
  }
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${match.url}/new`
  }, permissions.writeSavedQueries ? /*#__PURE__*/_react.default.createElement(_new.NewSavedQueryPage, null) : /*#__PURE__*/_react.default.createElement(_components.MissingPrivileges, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${match.url}/:savedQueryId`
  }, /*#__PURE__*/_react.default.createElement(_edit.EditSavedQueryPage, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${match.url}`
  }, /*#__PURE__*/_react.default.createElement(_list.QueriesPage, null)));
};
const SavedQueries = /*#__PURE__*/_react.default.memo(SavedQueriesComponent);
exports.SavedQueries = SavedQueries;