"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LiveQueriesPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _kibana = require("../../../common/lib/kibana");
var _actions_table = require("../../../actions/actions_table");
var _layouts = require("../../../components/layouts");
var _use_breadcrumbs = require("../../../common/hooks/use_breadcrumbs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LiveQueriesPageComponent = () => {
  (0, _use_breadcrumbs.useBreadcrumbs)('live_queries');
  const LeftColumn = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.liveQueriesHistory.pageTitle",
    defaultMessage: "Live queries history"
  }))))), []);
  return /*#__PURE__*/_react.default.createElement(_layouts.WithHeaderLayout, {
    leftColumn: LeftColumn,
    rightColumn: /*#__PURE__*/_react.default.createElement(NewLiveQueryButton, null),
    rightColumnGrow: false
  }, /*#__PURE__*/_react.default.createElement(_actions_table.ActionsTable, null));
};
const LiveQueriesPage = /*#__PURE__*/_react.default.memo(LiveQueriesPageComponent);
exports.LiveQueriesPage = LiveQueriesPage;
const NewLiveQueryButton = /*#__PURE__*/_react.default.memo(() => {
  const permissions = (0, _kibana.useKibana)().services.application.capabilities.osquery;
  const newQueryLinkProps = (0, _kibana.useRouterNavigate)('live_queries/new');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    fill: true
  }, newQueryLinkProps, {
    iconType: "plusInCircle",
    isDisabled: !(permissions.writeLiveQueries || permissions.runSavedQueries && (permissions.readSavedQueries || permissions.readPacks))
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.liveQueriesHistory.newLiveQueryButtonLabel",
    defaultMessage: "New live query"
  }));
});
NewLiveQueryButton.displayName = 'NewLiveQueryButton';