"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.semicolonWrapperCss = exports.resultComboBoxCss = exports.fieldSpanCss = exports.fieldIconCss = exports.euiSuperSelectCss = exports.descriptionWrapperCss = exports.buttonWrapperCss = exports.ECSFieldWrapperCss = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const resultComboBoxCss = {
  '&.euiComboBox': {
    position: 'relative',
    left: '-1px',
    '.euiComboBox__inputWrap': {
      borderRadius: '0 6px 6px 0'
    }
  }
};
exports.resultComboBoxCss = resultComboBoxCss;
const euiSuperSelectCss = {
  minWidth: '70px',
  borderRadius: '6px 0 0 6px',
  '.euiIcon': {
    padding: 0,
    width: '18px',
    background: 'none'
  }
};
exports.euiSuperSelectCss = euiSuperSelectCss;
const fieldIconCss = {
  width: '32px',
  '> svg': {
    padding: '0 6px !important'
  }
};
exports.fieldIconCss = fieldIconCss;
const fieldSpanCss = {
  paddingTop: '0 !important',
  paddingBottom: '0 !important',
  paddingLeft: '5px'
};
exports.fieldSpanCss = fieldSpanCss;
const descriptionWrapperCss = {
  overflow: 'hidden'
};
exports.descriptionWrapperCss = descriptionWrapperCss;
const semicolonWrapperCss = {
  marginTop: '28px'
};

// align the icon to the inputs
exports.semicolonWrapperCss = semicolonWrapperCss;
const buttonWrapperCss = {
  marginTop: '28px',
  width: '24px'
};
exports.buttonWrapperCss = buttonWrapperCss;
const ECSFieldWrapperCss = {
  maxWidth: '100%'
};
exports.ECSFieldWrapperCss = ECSFieldWrapperCss;