"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.PackQueriesTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _platforms = require("./queries/platforms");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PackQueriesTableComponent = ({
  data,
  isReadOnly,
  onDeleteClick,
  onEditClick,
  selectedItems,
  setSelectedItems
}) => {
  const renderDeleteAction = (0, _react.useCallback)(item => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "danger"
    // eslint-disable-next-line react/jsx-no-bind, react-perf/jsx-no-new-function-as-prop
    ,
    onClick: () => onDeleteClick && onDeleteClick(item),
    iconType: "trash",
    "aria-label": _i18n.i18n.translate('xpack.osquery.pack.queriesTable.deleteActionAriaLabel', {
      defaultMessage: 'Delete {queryName}',
      values: {
        queryName: item.id
      }
    })
  }), [onDeleteClick]);
  const renderEditAction = (0, _react.useCallback)(item => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "primary"
    // eslint-disable-next-line react/jsx-no-bind, react-perf/jsx-no-new-function-as-prop
    ,
    onClick: () => onEditClick && onEditClick(item),
    iconType: "pencil",
    "aria-label": _i18n.i18n.translate('xpack.osquery.pack.queriesTable.editActionAriaLabel', {
      defaultMessage: 'Edit {queryName}',
      values: {
        queryName: item.id
      }
    })
  }), [onEditClick]);
  const renderQueryColumn = (0, _react.useCallback)(query => /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "sql",
    fontSize: "s",
    paddingSize: "none",
    transparentBackground: true
  }, query), []);
  const renderPlatformColumn = (0, _react.useCallback)(platform => /*#__PURE__*/_react.default.createElement(_platforms.PlatformIcons, {
    platform: platform
  }), []);
  const renderVersionColumn = (0, _react.useCallback)(version => version ? `${version}` : _i18n.i18n.translate('xpack.osquery.pack.queriesTable.osqueryVersionAllLabel', {
    defaultMessage: 'ALL'
  }), []);
  const columns = (0, _react.useMemo)(() => [{
    field: 'id',
    name: _i18n.i18n.translate('xpack.osquery.pack.queriesTable.idColumnTitle', {
      defaultMessage: 'ID'
    }),
    width: '20%'
  }, {
    field: 'interval',
    name: _i18n.i18n.translate('xpack.osquery.pack.queriesTable.intervalColumnTitle', {
      defaultMessage: 'Interval (s)'
    }),
    width: '100px'
  }, {
    field: 'query',
    name: _i18n.i18n.translate('xpack.osquery.pack.queriesTable.queryColumnTitle', {
      defaultMessage: 'Query'
    }),
    render: renderQueryColumn
  }, {
    field: 'platform',
    name: _i18n.i18n.translate('xpack.osquery.pack.queriesTable.platformColumnTitle', {
      defaultMessage: 'Platform'
    }),
    render: renderPlatformColumn
  }, {
    field: 'version',
    name: _i18n.i18n.translate('xpack.osquery.pack.queriesTable.versionColumnTitle', {
      defaultMessage: 'Min Osquery version'
    }),
    render: renderVersionColumn
  }, ...(!isReadOnly ? [{
    name: _i18n.i18n.translate('xpack.osquery.pack.queriesTable.actionsColumnTitle', {
      defaultMessage: 'Actions'
    }),
    width: '120px',
    actions: [{
      render: renderEditAction
    }, {
      render: renderDeleteAction
    }]
  }] : [])], [isReadOnly, renderDeleteAction, renderEditAction, renderPlatformColumn, renderQueryColumn, renderVersionColumn]);
  const sorting = (0, _react.useMemo)(() => ({
    sort: {
      field: 'id',
      direction: 'asc'
    }
  }), []);
  const itemId = (0, _react.useCallback)(item => {
    var _item$id;
    return (_item$id = item.id) !== null && _item$id !== void 0 ? _item$id : '';
  }, []);
  const selection = (0, _react.useMemo)(() => ({
    onSelectionChange: setSelectedItems,
    initialSelected: selectedItems
  }), [selectedItems, setSelectedItems]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, (0, _extends2.default)({
    items: data,
    itemId: itemId,
    columns: columns,
    sorting: sorting
  }, !isReadOnly ? {
    selection,
    isSelectable: true
  } : {}));
};
const PackQueriesTable = /*#__PURE__*/_react.default.memo(PackQueriesTableComponent);
// eslint-disable-next-line import/no-default-export
exports.PackQueriesTable = PackQueriesTable;
var _default = PackQueriesTable;
exports.default = _default;