"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryDetailsFlyout = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const additionalZIndexStyle = {
  style: 'z-index: 6000'
};
const QueryDetailsFlyoutComponent = ({
  action,
  onClose
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
  size: "m",
  ownFocus: true,
  onClose: onClose,
  "aria-labelledby": "flyoutTitle",
  maskProps: additionalZIndexStyle // For an edge case to display above the alerts flyout
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
  hasBorder: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("h2", {
  id: "flyoutTitle"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.osquery.liveQueryActions.details.title",
  defaultMessage: "Query Details"
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.osquery.liveQueryActions.details.id",
  defaultMessage: "Id"
})), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xs"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
  fontSize: "m",
  paddingSize: "s",
  isCopyable: true
}, action.id)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.osquery.liveQueryActions.details.query",
  defaultMessage: "Query"
})), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xs"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
  language: "sql",
  fontSize: "m",
  paddingSize: "s",
  isCopyable: true
}, action.query)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}))));
const QueryDetailsFlyout = /*#__PURE__*/_react.default.memo(QueryDetailsFlyoutComponent);
exports.QueryDetailsFlyout = QueryDetailsFlyout;