"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OsqueryAppEmptyState = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _common = require("@kbn/fleet-plugin/common");
var _public = require("@kbn/fleet-plugin/public");
var _kibana = require("../common/lib/kibana");
var _osquery_icon = require("./osquery_icon");
var _use_breadcrumbs = require("../common/hooks/use_breadcrumbs");
var _common2 = require("../../common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OsqueryAppEmptyStateComponent = () => {
  (0, _use_breadcrumbs.useBreadcrumbs)('base');
  const {
    application: {
      getUrlForApp,
      navigateToApp
    }
  } = (0, _kibana.useKibana)().services;
  const integrationHref = (0, _react.useMemo)(() => getUrlForApp(_common.INTEGRATIONS_PLUGIN_ID, {
    path: _public.pagePathGetters.integration_details_overview({
      pkgkey: _common2.OSQUERY_INTEGRATION_NAME
    })[1]
  }), [getUrlForApp]);
  const integrationClick = (0, _react.useCallback)(event => {
    if (!(0, _kibana.isModifiedEvent)(event) && (0, _kibana.isLeftClickEvent)(event)) {
      event.preventDefault();
      return navigateToApp(_common.INTEGRATIONS_PLUGIN_ID, {
        path: _public.pagePathGetters.integration_details_overview({
          pkgkey: _common2.OSQUERY_INTEGRATION_NAME
        })[1]
      });
    }
  }, [navigateToApp]);
  const pageHeader = (0, _react.useMemo)(() => ({
    iconType: _osquery_icon.OsqueryIcon,
    pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.emptyState.pageTitle",
      defaultMessage: "Add Osquery Manager"
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.emptyState.pageDescription",
      defaultMessage: "Add this integration to run and schedule queries for Elastic Agent."
    }),
    rightSideItems: [
    /*#__PURE__*/
    // eslint-disable-next-line @elastic/eui/href-or-on-click
    _react.default.createElement(_eui.EuiButton, {
      key: "button",
      fill: true,
      href: integrationHref,
      onClick: integrationClick,
      iconType: "plusInCircleFilled",
      "data-test-subj": "osquery-add-integration-button"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.emptyState.addOsqueryManagerButton",
      defaultMessage: "Add Osquery Manager"
    }))]
  }), [integrationClick, integrationHref]);
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    isEmptyState: true,
    pageHeader: pageHeader
  });
};
const OsqueryAppEmptyState = /*#__PURE__*/_react.default.memo(OsqueryAppEmptyStateComponent);
exports.OsqueryAppEmptyState = OsqueryAppEmptyState;