"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionAgentsStatusBadges = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _agent_status = require("./services/agent_status");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActionAgentsStatusBadges = /*#__PURE__*/(0, _react.memo)(({
  agentStatus,
  expired
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "m"
}, _agent_status.AGENT_STATUSES.map(status => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  key: status,
  grow: false
}, /*#__PURE__*/_react.default.createElement(AgentStatusBadge, {
  expired: expired,
  status: status,
  count: agentStatus[status] || 0
})))));
exports.ActionAgentsStatusBadges = ActionAgentsStatusBadges;
ActionAgentsStatusBadges.displayName = 'ActionAgentsStatusBadges';
const AgentStatusBadge = /*#__PURE__*/(0, _react.memo)(({
  expired,
  status,
  count
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
  color: (0, _agent_status.getColorForAgentStatus)(status)
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "s"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, (0, _agent_status.getLabelForAgentStatus)(status, expired)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
  size: "s",
  color: "subdued"
}, count))))));
AgentStatusBadge.displayName = 'AgentStatusBadge';