"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createLiveQueryRequestBodySchema = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _osqueryIoTsTypes = require("@kbn/osquery-io-ts-types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createLiveQueryRequestBodySchema = t.partial({
  agent_ids: t.array(t.string),
  agent_all: t.union([t.boolean, t.undefined]),
  agent_platforms: t.array(t.string),
  agent_policy_ids: t.array(t.string),
  query: _osqueryIoTsTypes.queryOrUndefined,
  queries: _osqueryIoTsTypes.arrayQueries,
  saved_query_id: _osqueryIoTsTypes.savedQueryIdOrUndefined,
  timeout: _osqueryIoTsTypes.timeoutOrUndefined,
  ecs_mapping: _osqueryIoTsTypes.ecsMappingOrUndefined,
  pack_id: _osqueryIoTsTypes.packIdOrUndefined,
  alert_ids: t.array(t.string),
  case_ids: t.array(t.string),
  event_ids: t.array(t.string),
  metadata: t.union([t.object, t.undefined])
});
exports.createLiveQueryRequestBodySchema = createLiveQueryRequestBodySchema;