"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultSummaryClient = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _moment = _interopRequireDefault(require("moment"));
var _constants = require("../../../common/slo/constants");
var _services = require("../../domain/services");
var _date_range = require("../../domain/services/date_range");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DefaultSummaryClient {
  constructor(esClient) {
    this.esClient = esClient;
  }
  async computeSummary(slo, instanceId = _sloSchema.ALL_VALUE) {
    var _result$aggregations$, _result$aggregations, _result$aggregations$2, _result$aggregations$3, _result$aggregations2, _result$aggregations3;
    const dateRange = (0, _date_range.toDateRange)(slo.timeWindow);
    const isDefinedWithGroupBy = slo.groupBy !== _sloSchema.ALL_VALUE;
    const hasInstanceId = instanceId !== _sloSchema.ALL_VALUE;
    const extraInstanceIdFilter = isDefinedWithGroupBy && hasInstanceId ? [{
      term: {
        'slo.instanceId': instanceId
      }
    }] : [];
    const result = await this.esClient.search({
      index: _constants.SLO_DESTINATION_INDEX_PATTERN,
      size: 0,
      query: {
        bool: {
          filter: [{
            term: {
              'slo.id': slo.id
            }
          }, {
            term: {
              'slo.revision': slo.revision
            }
          }, {
            range: {
              '@timestamp': {
                gte: dateRange.from.toISOString(),
                lt: dateRange.to.toISOString()
              }
            }
          }, ...extraInstanceIdFilter]
        }
      },
      ...(_sloSchema.occurrencesBudgetingMethodSchema.is(slo.budgetingMethod) && {
        aggs: {
          good: {
            sum: {
              field: 'slo.numerator'
            }
          },
          total: {
            sum: {
              field: 'slo.denominator'
            }
          }
        }
      }),
      ...(_sloSchema.timeslicesBudgetingMethodSchema.is(slo.budgetingMethod) && {
        aggs: {
          good: {
            sum: {
              field: 'slo.isGoodSlice'
            }
          },
          total: {
            value_count: {
              field: 'slo.isGoodSlice'
            }
          }
        }
      })
    });

    // @ts-ignore value is not type correctly
    const good = (_result$aggregations$ = (_result$aggregations = result.aggregations) === null || _result$aggregations === void 0 ? void 0 : (_result$aggregations$2 = _result$aggregations.good) === null || _result$aggregations$2 === void 0 ? void 0 : _result$aggregations$2.value) !== null && _result$aggregations$ !== void 0 ? _result$aggregations$ : 0;
    // @ts-ignore value is not type correctly
    const total = (_result$aggregations$3 = (_result$aggregations2 = result.aggregations) === null || _result$aggregations2 === void 0 ? void 0 : (_result$aggregations3 = _result$aggregations2.total) === null || _result$aggregations3 === void 0 ? void 0 : _result$aggregations3.value) !== null && _result$aggregations$3 !== void 0 ? _result$aggregations$3 : 0;
    const sliValue = (0, _services.computeSLI)(good, total);
    const initialErrorBudget = 1 - slo.objective.target;
    let errorBudget;
    if (_sloSchema.calendarAlignedTimeWindowSchema.is(slo.timeWindow) && _sloSchema.timeslicesBudgetingMethodSchema.is(slo.budgetingMethod)) {
      const totalSlices = computeTotalSlicesFromDateRange(dateRange, slo.objective.timesliceWindow);
      const consumedErrorBudget = sliValue < 0 ? 0 : (total - good) / (totalSlices * initialErrorBudget);
      errorBudget = (0, _services.toErrorBudget)(initialErrorBudget, consumedErrorBudget);
    } else {
      const consumedErrorBudget = sliValue < 0 ? 0 : (1 - sliValue) / initialErrorBudget;
      errorBudget = (0, _services.toErrorBudget)(initialErrorBudget, consumedErrorBudget, _sloSchema.calendarAlignedTimeWindowSchema.is(slo.timeWindow));
    }
    return {
      sliValue,
      errorBudget,
      status: (0, _services.computeSummaryStatus)(slo, sliValue, errorBudget)
    };
  }
}
exports.DefaultSummaryClient = DefaultSummaryClient;
function computeTotalSlicesFromDateRange(dateRange, timesliceWindow) {
  const dateRangeDurationInUnit = (0, _moment.default)(dateRange.to).diff(dateRange.from, (0, _sloSchema.toMomentUnitOfTime)(timesliceWindow.unit));
  return Math.ceil(dateRangeDurationInUnit / timesliceWindow.value);
}