"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageSLO = void 0;
var _constants = require("../../../common/slo/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ManageSLO {
  constructor(repository, transformManager, summaryTransformManager) {
    this.repository = repository;
    this.transformManager = transformManager;
    this.summaryTransformManager = summaryTransformManager;
  }
  async enable(sloId) {
    const slo = await this.repository.findById(sloId);
    if (slo.enabled) {
      return;
    }
    await this.summaryTransformManager.start((0, _constants.getSLOSummaryTransformId)(slo.id, slo.revision));
    await this.transformManager.start((0, _constants.getSLOTransformId)(slo.id, slo.revision));
    slo.enabled = true;
    slo.updatedAt = new Date();
    await this.repository.save(slo);
  }
  async disable(sloId) {
    const slo = await this.repository.findById(sloId);
    if (!slo.enabled) {
      return;
    }
    await this.summaryTransformManager.stop((0, _constants.getSLOSummaryTransformId)(slo.id, slo.revision));
    await this.transformManager.stop((0, _constants.getSLOTransformId)(slo.id, slo.revision));
    slo.enabled = false;
    slo.updatedAt = new Date();
    await this.repository.save(slo);
  }
}
exports.ManageSLO = ManageSLO;