"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetSLOInstances = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _constants = require("../../../common/slo/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class GetSLOInstances {
  constructor(repository, esClient) {
    this.repository = repository;
    this.esClient = esClient;
  }
  async execute(sloId) {
    var _result$aggregations$, _result$aggregations;
    const slo = await this.repository.findById(sloId);
    if (slo.groupBy === _sloSchema.ALL_VALUE) {
      return {
        groupBy: _sloSchema.ALL_VALUE,
        instances: []
      };
    }
    const result = await this.esClient.search({
      index: _constants.SLO_DESTINATION_INDEX_PATTERN,
      size: 0,
      query: {
        bool: {
          filter: [{
            range: {
              '@timestamp': {
                gte: 'now-7d'
              }
            }
          }, {
            term: {
              'slo.id': slo.id
            }
          }, {
            term: {
              'slo.revision': slo.revision
            }
          }]
        }
      },
      aggs: {
        instances: {
          terms: {
            size: 1000,
            field: 'slo.instanceId'
          }
        }
      }
    });

    // @ts-ignore
    const buckets = (_result$aggregations$ = result === null || result === void 0 ? void 0 : (_result$aggregations = result.aggregations) === null || _result$aggregations === void 0 ? void 0 : _result$aggregations.instances.buckets) !== null && _result$aggregations$ !== void 0 ? _result$aggregations$ : [];
    const instances = buckets.map(bucket => bucket.key);
    return {
      groupBy: slo.groupBy,
      instances
    };
  }
}
exports.GetSLOInstances = GetSLOInstances;