"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloSummary = SloSummary;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_slo_summary = require("../hooks/use_slo_summary");
var _chart_data_formatter = require("../../../utils/slo/chart_data_formatter");
var _slo_sparkline = require("./slo_sparkline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloSummary({
  slo,
  historicalSummary = [],
  historicalSummaryLoading
}) {
  const {
    sliValue,
    sloTarget,
    errorBudgetRemaining
  } = (0, _use_slo_summary.useSloFormattedSummary)(slo);
  const isSloFailed = slo.summary.status === 'VIOLATED' || slo.summary.status === 'DEGRADING';
  const titleColor = isSloFailed ? 'danger' : '';
  const errorBudgetBurnDownData = (0, _chart_data_formatter.formatHistoricalData)(historicalSummary, 'error_budget_remaining');
  const historicalSliData = (0, _chart_data_formatter.formatHistoricalData)(historicalSummary, 'sli_value');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "spaceBetween",
    gutterSize: "l",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      maxWidth: 200
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    responsive: false,
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    description: _i18n.i18n.translate('xpack.observability.slo.slo.stats.objective', {
      defaultMessage: '{objective} target',
      values: {
        objective: sloTarget
      }
    }),
    title: sliValue,
    textAlign: "right",
    titleColor: titleColor,
    titleSize: "m",
    reverse: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_slo_sparkline.SloSparkline, {
    chart: "line",
    id: "sli_history",
    state: isSloFailed ? 'error' : 'success',
    data: historicalSliData,
    isLoading: historicalSummaryLoading
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      maxWidth: 200
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    responsive: false,
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    description: _i18n.i18n.translate('xpack.observability.slo.slo.stats.budgetRemaining', {
      defaultMessage: 'Budget remaining'
    }),
    textAlign: "right",
    title: errorBudgetRemaining,
    titleColor: titleColor,
    titleSize: "m",
    reverse: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_slo_sparkline.SloSparkline, {
    chart: "area",
    id: "error_budget_burn_down",
    state: isSloFailed ? 'error' : 'success',
    data: errorBudgetBurnDownData,
    isLoading: historicalSummaryLoading
  })))));
}