"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloIndicatorTypeBadge = SloIndicatorTypeBadge;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _i18n = require("@kbn/i18n");
var _kibana_react = require("../../../../utils/kibana_react");
var _convert_sli_apm_params_to_apm_app_deeplink_url = require("../../../../utils/slo/convert_sli_apm_params_to_apm_app_deeplink_url");
var _indicator = require("../../../../utils/slo/indicator");
var _labels = require("../../../../utils/slo/labels");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloIndicatorTypeBadge({
  slo,
  color
}) {
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    }
  } = (0, _kibana_react.useKibana)().services;
  const handleNavigateToApm = () => {
    if (slo.indicator.type === 'sli.apm.transactionDuration' || slo.indicator.type === 'sli.apm.transactionErrorRate') {
      const {
        indicator: {
          params: {
            environment,
            filter,
            service,
            transactionName,
            transactionType
          }
        },
        timeWindow: {
          duration
        }
      } = slo;
      const url = (0, _convert_sli_apm_params_to_apm_app_deeplink_url.convertSliApmParamsToApmAppDeeplinkUrl)({
        duration,
        environment,
        filter,
        service,
        transactionName,
        transactionType
      });
      navigateToUrl(basePath.prepend(url));
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: color !== null && color !== void 0 ? color : _uiTheme.euiLightVars.euiColorDisabled
  }, (0, _labels.toIndicatorTypeLabel)(slo.indicator.type))), (0, _indicator.isApmIndicatorType)(slo.indicator.type) && 'service' in slo.indicator.params && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      maxWidth: 100
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: _i18n.i18n.translate('xpack.observability.slo.indicatorTypeBadge.exploreInApm', {
      defaultMessage: 'View {service} details',
      values: {
        service: slo.indicator.params.service
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: color !== null && color !== void 0 ? color : _uiTheme.euiLightVars.euiColorDisabled,
    onClick: handleNavigateToApm,
    onClickAriaLabel: _i18n.i18n.translate('xpack.observability.slo.indicatorTypeBadge.exploreInApm', {
      defaultMessage: 'View {service} details',
      values: {
        service: slo.indicator.params.service
      }
    })
  }, slo.indicator.params.service))));
}