"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutdatedSloSearchBar = OutdatedSloSearchBar;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function OutdatedSloSearchBar({
  onSearch,
  onRefresh,
  initialSearch = ''
}) {
  const [tempSearch, setTempSearch] = (0, _react.useState)(initialSearch);
  const [search, setSearch] = (0, _react.useState)(initialSearch);
  const refreshOrUpdateSearch = () => {
    if (tempSearch !== search) {
      setSearch(tempSearch);
      onSearch(tempSearch);
    } else {
      onRefresh();
    }
  };
  const handleClick = event => setTempSearch(event.target.value);
  const handleKeyPress = event => {
    if (event.key === 'Enter') {
      refreshOrUpdateSearch();
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "o11ySlosOutdatedDefinitionsFieldSearch",
    fullWidth: true,
    value: tempSearch,
    onChange: handleClick,
    onKeyDown: handleKeyPress
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, search === tempSearch && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "o11ySlosOutdatedDefinitionsRefreshButton",
    iconType: "refresh",
    onClick: refreshOrUpdateSearch
  }, _i18n.i18n.translate('xpack.observability.slosOutdatedDefinitions.refreshButtonLabel', {
    defaultMessage: 'Refresh'
  })), search !== tempSearch && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "o11ySlosOutdatedDefinitionsUpdateButton",
    iconType: "kqlFunction",
    color: "success",
    fill: true,
    onClick: refreshOrUpdateSearch
  }, _i18n.i18n.translate('xpack.observability.slosOutdatedDefinitions.updateButtonLabel', {
    defaultMessage: 'Update'
  }))));
}