"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutdatedSlo = OutdatedSlo;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _slo_delete_confirmation_modal = require("../../components/slo/delete_confirmation_modal/slo_delete_confirmation_modal");
var _slo_time_window_badge = require("../slos/components/badges/slo_time_window_badge");
var _slo_indicator_type_badge = require("../slos/components/badges/slo_indicator_type_badge");
var _use_delete_slo = require("../../hooks/slo/use_delete_slo");
var _use_reset_slo = require("../../hooks/slo/use_reset_slo");
var _slo_reset_confirmation_modal = require("../../components/slo/reset_confirmation_modal/slo_reset_confirmation_modal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function OutdatedSlo({
  slo,
  onReset,
  onDelete
}) {
  const {
    mutateAsync: resetSlo,
    isLoading: isResetLoading
  } = (0, _use_reset_slo.useResetSlo)();
  const {
    mutateAsync: deleteSlo,
    isLoading: isDeleteLoading
  } = (0, _use_delete_slo.useDeleteSlo)();
  const [isDeleteConfirmationModalOpen, setDeleteConfirmationModalOpen] = (0, _react.useState)(false);
  const [isResetConfirmationModalOpen, setResetConfirmationModalOpen] = (0, _react.useState)(false);
  const handleDelete = () => {
    setDeleteConfirmationModalOpen(true);
  };
  const handleDeleteConfirm = async () => {
    setDeleteConfirmationModalOpen(false);
    await deleteSlo({
      id: slo.id,
      name: slo.name
    });
    onDelete();
  };
  const handleDeleteCancel = () => {
    setDeleteConfirmationModalOpen(false);
  };
  const handleReset = () => {
    setResetConfirmationModalOpen(true);
  };
  const handleResetConfirm = async () => {
    setResetConfirmationModalOpen(false);
    await resetSlo({
      id: slo.id,
      name: slo.name
    });
    onReset();
  };
  const handleResetCancel = () => {
    setResetConfirmationModalOpen(false);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("span", null, slo.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    responsive: false,
    gutterSize: "s",
    alignItems: "center",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_slo_indicator_type_badge.SloIndicatorTypeBadge, {
    slo: slo
  }), /*#__PURE__*/_react.default.createElement(_slo_time_window_badge.SloTimeWindowBadge, {
    slo: slo
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "o11ySlosOutdatedDefinitionsResetButton",
    color: "primary",
    fill: true,
    isLoading: isResetLoading,
    onClick: handleReset
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.slosOutdatedDefinitions.resetButtonLabel",
    defaultMessage: "Reset"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "o11ySlosOutdatedDefinitionsDeleteButton",
    color: "danger",
    fill: true,
    isLoading: isDeleteLoading,
    onClick: handleDelete
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.slosOutdatedDefinitions.deleteButtonLabel",
    defaultMessage: "Delete"
  })))), isDeleteConfirmationModalOpen ? /*#__PURE__*/_react.default.createElement(_slo_delete_confirmation_modal.SloDeleteConfirmationModal, {
    slo: slo,
    onCancel: handleDeleteCancel,
    onConfirm: handleDeleteConfirm
  }) : null, isResetConfirmationModalOpen ? /*#__PURE__*/_react.default.createElement(_slo_reset_confirmation_modal.SloResetConfirmationModal, {
    slo: slo,
    onCancel: handleResetCancel,
    onConfirm: handleResetConfirm
  }) : null);
}