"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCopyToJson = useCopyToJson;
var _i18n = require("@kbn/i18n");
var _kibana_react = require("../../../utils/kibana_react");
var _process_slo_form_values = require("../helpers/process_slo_form_values");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useCopyToJson({
  trigger,
  getValues
}) {
  const {
    notifications
  } = (0, _kibana_react.useKibana)().services;
  const handleCopyToJson = async () => {
    const isValid = await trigger();
    if (!isValid) {
      return;
    }
    const values = (0, _process_slo_form_values.transformCreateSLOFormToCreateSLOInput)(getValues());
    try {
      await copyTextToClipboard(JSON.stringify(values, null, 2));
      notifications.toasts.add({
        title: _i18n.i18n.translate('xpack.observability.slo.sloEdit.copyJsonNotification', {
          defaultMessage: 'JSON copied to clipboard'
        })
      });
    } catch (e) {
      notifications.toasts.add({
        title: _i18n.i18n.translate('xpack.observability.slo.sloEdit.copyJsonFailedNotification', {
          defaultMessage: 'Could not copy JSON to clipboard'
        })
      });
    }
  };
  const copyTextToClipboard = async text => {
    var _window$navigator;
    if (!((_window$navigator = window.navigator) !== null && _window$navigator !== void 0 && _window$navigator.clipboard)) {
      throw new Error('Could not copy to clipboard!');
    }
    await window.navigator.clipboard.writeText(text);
  };
  return handleCopyToJson;
}